# The Weighted Cfg Constraint

George Katsirelos, Nina Narodytska and Toby Walsh University of New South Wales and NICTA, Sydney, Australia, Abstract. We introduce the weighted CFG constraint and propose a propagation algorithm that enforces domain consistency in O(n 3 |G|) time. We show that this algorithm can be decomposed into a set of primitive arithmetic constraints without hindering propagation.

## 1 Introduction

One very promising method for rostering and other domains is to specify constraints via grammars or automata that accept some language. We can specify constraints in this way on, for instance, the number of consecutive night shifts or the number of days off in each 7 day period. With the REGULAR constraint [4], we specify the acceptable assignments to a sequence of variables by a deterministic finite automaton. One limitation of this approach is that the automaton may need to be large. For example, there are regular languages which can only be defined by an automaton with an exponential number of states. Researchers have therefore looked higher up the Chomsky hierarchy. In particular, the CFG constraint [8,6] permits us to specify constraints using any contextfree grammar. In this paper, we consider a further generalization to the weighted CFG
constraint. This can model over-constrained problems and problems with preferences.

## 2 The Weighted Cfg Constraint

In a context-free grammar, rules have a left-hand side with just one non-terminal, and a right-hand side consisting of terminals and non-terminals. Any context-free grammar can be written in Chomsky form in which the right-hand size of a rule is just one terminal or two non-terminals. The weighted WCFG(G, W, z, [X1**, . . . , X**n]) constraint holds iff an assignment X forms a string belonging to the grammar G and the minimal weight of a derivation of X less than or equal to z. The matrix W defines weights of productions in the grammar G. The weight of a derivation is the sum of production weights used in the derivation. The WCFG constraint is domain consistent iff for each variable, every value in its domain can be extended to an assignment satisfying the constraint.

We give a propagator for the WCFG constraint based on an extension of the **CY K**
parser to probabilistic grammars [3]. We assume that G is in Chomsky normal form and with a single start non-terminal S. The algorithm has two stages. In the first, we construct a dynamic programing table V [**i, j**] where an element A of V [**i, j**] is a potential non-terminal that generates a substring [Xi**, . . . , X**i+j ]. We compute a lower bound l[**i, j, A**] on the minimal weight of a derivation from A. In the second stage, we move from V [1, n] to the bottom of table V . For an element A of V [**i, j**], we compute an