space. The space is subdivided so that there is a constant, predefined, maximum number of entities (which, per analogy with the N-body problem, we will call *bodies)* in each subspace.

We call *cell* a node of the tree and its associated subspace. 

Depending on the way the space is decomposed, the number of sub cells varies. Often 2D spaces are cut in four cells yielding 4-trees or "quadtrees", and 3D spaces are decomposed in eight cells, producing 8-trees or "octrees". The number of bodies per leaf cell is variable. Some methods can put only one body per cell, others put several bodies in one cell. Bodies are only "present" in the leaf spaces, and super cells aggregate the data of their sub cells.

It is necessary to subdivide a cell when the maximum number of bodies per cell is reached, and n cells merge into one when there is less than the maximum number of bodies per cell in all the n cells. Therefore, this subdivision is adaptive, and changes during time.

We call a "level" all the cells of the tree at a given depth in 

![0_image_2.png](0_image_2.png)

the tree. The nature of the subdivision yields many subdivided cells where there are many bodies. The intuition of the method is that it is easy to identify dense groups of bodies (that is places where interactions are stronger) by looking at a representation of the subdivided space (figure 1).

## Finding Organizations With The N-Tree

Our method relies on the use of the n-tree to detect organizations, therefore sharing the use of this tree both for the FMM and for the organization detection.

The main idea is to consider only the lower levels of the tree as shown on figures 2 and 3, and then to cut this set of cells in groups of adjacent cells. The tree in figure 3 represents the subdivided space of the figure 2. There are at most three bodies per cell here. The search for organizations begins by considering only the lower levels of the tree. That is, cutting the bottom of the tree (here under the horizontal dotted line). In this restricted set of cells, we remove all cells that do not contain bodies (in grey on the figure). Notice that this selects only "leaf" cells. This set must then be cut in groups of adjacent cells. These groups can be considered a good approximation of searched 

![0_image_0.png](0_image_0.png) organizations.

![0_image_1.png](0_image_1.png)

In two dimensions, one can also see the subdivisions of 

![0_image_3.png](0_image_3.png) space as being higher in a third dimension. The more space is subdivided, the higher a point in space is. As subdivision matches body density, the denser the bodies are the higher is their third coordinate. The idea is then to cut this representation and consider only the cut parts to search for dense groups of bodies, as shown on Figure 4.