
## Algorithm

The organization detection algorithm does not work directly on the n-tree, but on a set of cells C corresponding to some levels of the n-tree. They correspond to all the cells of the tree that are deeper than a given depth d.

In this set, we keep only the leaf cells, as only these cells 
"contain" bodies.

The algorithm will then try to cut this set in groups of 

![0_image_1.png](0_image_1.png)

adjacent cells. We will consider these groups as organizations. Adjacent cells are cells that share a face, an edge or a point (Figure 5).

The creation of the groups can be done easily with a (
2)
algorithm, with  the number of cells in C. Consider one cell  taken at random in C and remove it from C. Consider all the other cells of C and check if they share a face, edge or point with . If they do, put them in the same group and remove them from C. When there are no more cells of C adjacent to , and if C 
still contains cells, create another group, choose randomly another cell ' and restart the procedure. Do this until C is empty.

$${\mathfrak{g o r o r p o i n t}}(\ {\mathfrak{g}}\ )$$

![0_image_2.png](0_image_2.png)

However, the group creation can be achieved faster by using the n-tree. It is not necessary to explore the entire set C to find adjacent cells. Instead, it is possible to explore the tree.
To find the adjacent cells of a cell c taken at random in C and removed from it, start from the root cell and look for all child cells that could intersect or contain an area around the cell c. Do this recursively until you reach leaf cells. Only in this restricted set of cells, search for adjacent cells. Restart this procedure for each newly found cell until no more adjacent cell is found.

![0_image_0.png](0_image_0.png)

The difficulty in this method is that it is difficult to compute which cells are intersecting with the area around a leaf cell. A simple approximation can be to use a cube or square instead of a sphere or disk around the considered cell.

## Results

The results presented here are in two dimensions. This allows an easy representation of the levels. On each figure, a boid simulation is shown on the left and the space subdivision is shown on the right.

The boid simulation uses several species that repulse one another and form groups of high interaction. The space subdivision is in two dimensions, with a third dimension showing the depth in the quadtree. Levels close to the root are in darker and near the leaves are lighter. The cut threshold has been set to 5 levels, and levels higher than this have been colored in red, they show the organizations detected. The maximum number of bodies per cell is ten. The Figure 6 shows the boid simulation at different time steps.