# A Multiagent Urban Traffic Simulation Part Ii: Dealing With The Extraordinary

Éric Daudé, Pierrick Tranouez, Patrice Langlois Abstract— **In Probabilistic Risk Management, risk is** 
characterized by two quantities: the magnitude (or severity) of the adverse consequences that can potentially result from the given activity or action, and by the likelihood of occurrence of the given adverse consequences.

But a risk seldom exists in isolation: chain of consequences must be examined, as the outcome of one risk can increase the likelihood of other risks. Systemic theory must complement classic PRM. Indeed these chains are composed of many different elements, all of which may have a critical importance at many different levels.

Furthermore, when urban catastrophes are envisioned, space and time constraints are key determinants of the workings and dynamics of these chains of catastrophes: models must include a correct spatial topology of the studied risk.

Finally, literature insists on the importance small events can have on the risk on a greater scale: urban risks management models belong to self-organized criticality theory. We chose multiagent systems to incorporate this property in our model: the behavior of an agent can transform the dynamics of important groups of them.

Index Terms— Risk management, self-organized criticality, multiagent systems, modeling, simulation.

## I. Introduction

S
PACE is an important factor of risks situations, not only as a support, but also as an actor in itself of the situation. Risk is space related. In epidemic contexts such as cholera, presence and density of the *vibrio cholera* are dependent both on aquatic reservoir and on the density of population in the environment. Risk has spatial impacts. In environmental context, *flash floods* caused high damages because of their torrential nature and of their high spatial concentrations. Risk management makes tracks in space, and risk sometimes stands to management. In technological context, urban land use and planning reveals some tensions between industrial and residential areas. Risks are multilayered (world, nations, cities) and imply different kinds of actors, human and non-human. Fight against a possible A *flu* pandemic implies many actors at different levels (World Health Organization, national centers for disease control such as INSERM, local government and doctors) and control measures to reduce risks are both global (air traffic limitation) and local (public services closure). Furthermore, risks are dynamic. In industrial context, one can observe *Domino effect* as an explosion in one site produces secondary accidents in the neighborhood, due to the high concentration of activities. Risk is defined as a probability of space-time interaction between a source and a target [1]. Four concepts are relevant to this definition and are linked to capture the risk: hazard, intensity, vulnerability and resilience (figure 1).

![0_image_0.png](0_image_0.png)

- Hazard represents the occurrence probability of an alteration into the source that could have effects on target: the probability of emergence or reemergence of a virus for example;
- Intensity is viewed as an output of the source, it depends on the power and duration of the phenomenon and of the involved surface area: the volume and extension of a toxic cloud for example; - Vulnerability is an input of the target, it measures at the same time the sensitivity of the target to alterations in its environment, and the related 