methods to choose other paths to reach their destination. MOSAIIC is concerned by situations where contextual mobility can occur and can diffuse or have large consequences on the global circulation. 

We call *contextual mobility* a mobility which is associated to short-range goals (to avoid a crowd) and whose result differs from the initial planning (to change a destination). We will now consider an urban industrial accident. This accident has a finite extension area and well-determined intensity, represented by a buffer. Inside this buffer, a proportion of people, related to intensity, want to escape. Outside this buffer, behaviors are less reactive. Some want to escape, others want to see and for others "show must go on", and they want to follow their way. We have then defined different kinds of behaviors and methods related to these different goals: - *Chicken behavior*: the goal is to find the opposite direction of the source (the buffer), and to drive following this way; - *Bystander behavior*: the goal is to find the source of danger and to go there. If agent is already in the place, then he stays here; - *Pragmatic behavior*: here the agent selects a new destination in the network and tries to reach it. This behavior simulates the fact that some people will want to reach their children at school or husband or wife at their working place; - *Wandering behavior*: there is no goal, this behavior is the sign of distress. At each time step, just select a road and go there. - *Roadrunner behavior*: this method consists in always selecting the less congested road and to go there. This method can be connected to the Chicken or Bystander behavior; - *Sheep behavior*: here agent follows the crowd whatever the direction. We will now present implementations of these behaviors.

IV. SIMULATION OF BEHAVIORS
We will discuss here how the behaviors themselves can be implemented, not why or when one or the other will be chosen.

## A. Behaviors Classification

In order to implement them, we will distinguish three *categories* of behavior: global, planar and local. These categories are based on the actual behavior, and not on the motivations behind it.

A *global* behavior is one that makes a reasoning about the road network. *Pragmatic* behavior will probably fall in this category: the agent will try to find a good path to his newly decided destination using his knowledge of the network. *Bystander* can also fall here. A *planar* decision also chooses a destination but tries to reach it using orientation as if no roads existed, as if the vehicle was on an open plan. Of course the network will offer constraints, but a general cardinal like direction will guide the agent. Chicken and possibly B*ystander* will fall in this category. This means there are two sub-behaviors in by standing. A *local* decision is one based on local-only data: Wandering, *Roadrunner* and *Sheep* will fall there.

## B. Class Implementations

Global behaviors are implemented in the agents to allow them to reach their initial destination.

Local require little complexity. *Wandering* is trivial, *Roadrunner* and *Sheep* differ only by the sign of their optimization. We also implemented a simple anti-loop measure: *Roadrunners* for example will choose the less congested road unless they already went recently through this one.

Planar require the ability to choose an edge out of a node based on a global direction. Depending on what the modeler desires, he can choose a distance from the current road intersection, and the agent will choose the intersection at less than the selected distance (expressed in Euclidean distance or number of edges in a path leading to it) that is the closest to the desired direction. An anti-loop measure can be added.

## C. Examples Of Simulation

The behaviors previously described are ways of coping with an extraordinary situation. Most urban important accidents will have their consequences felt locally at the beginning, before it spreads. The evolution of the perturbation will be like waves spreading from the initial locus outward. If the extraordinary behaviors are the waves, the 