# A Local Search Modeling For Constrained Optimum Paths Problems (Extended Abstract)

Quang Dung Pham Universite catholique de Louvain ´
B-1348 Louvain-la-Neuve, Belgium quang.pham@uclouvain.be Yves Deville Universite catholique de Louvain ´
B-1348 Louvain-la-Neuve, Belgium yves.deville@uclouvain.be Pascal van Hentenryck Brown University, Box 1910 Providence, RI 02912, USA
pvh@cs.brown.edu Constrained Optimum Path (COP) problems appear in many real-life applications, especially on communication networks. Some of these problems have been considered and solved by specific techniques which are usually difficult to extend. In this paper, we introduce a novel local search modeling for solving some COPs by local search. The modeling features the compositionality, modularity, reuse and strengthens the benefits of Constrained-Based Local Search [1]. We also apply the modeling to the edge-disjoint paths problem (EDP). Computational results show the significance of the approach.

## 1 Introduction

Constrained Optimum Path (COP) problems, where optimum path from origin to destination satisfying additional constraints must be found, appear in many real-life applications, especially on communication and transportation networks. These problems have attracted considerable attention from different research communities: operations research, telecommunications because of its various applications (see [2] and the references therein).

Most of COP problems are NP-hard. Some instances can be solved efficiently by specific techniques, for instance, branch and bound using a Lagrangian-based bound [3], vertex-labeling [4], etc. These techniques seem to be sophisticated and depend on particular constraints and objective functions to be optimized. Moreover, they are difficult to extend, for example, when we face with generalized problems where more constraints are required to be satisfied. We propose in this paper a novel approach for modeling and solving some COP problems by local search where the desired paths are elementary (i.e.

no repeated nodes). The objective of this work is to extend the LS(Graph & Tree) framework [5]
by the design and the implementation of abstractions allowing to easily model and solve some COP problems using this approach. The computational model features compositionality, modularity, reuse, and strengthens the local search modeling benefits of Constraint-Based Local Search [1] which provides the separation of concerns.

The proposed computational model has been applied to the EDP problem. Computational results show the significance of the approach.

## 2 Modeling Paths With Spanning Trees

We introduce in this section the proposed approach for modeling COP problems with spanning trees. We first give somes definitions and notations over graphs. Our framework considers both directed and undirected graphs but for simplicity, we consider in this presentation only undirected graphs.

Given an undirected graph g, we denote V(g), E(g) respectively the set of nodes and the set of edges of g.