In this paper, we only consider elementary paths, henceforth we use the word "path" instead of
"elementary path" if there is no ambiguity. A graph is connected if and only if there exists a path from u to v,∀u, v ∈V(g). A tree is an undirected connected graph containing no cycles. A spanning tree tr of an undirected connected graph g is a tree spanning all the nodes of g: V(tr) = V(g) and E(tr) ⊆ E(g). A
tree tr is called a rooted tree at r if the node r has been designated the root. Each edge of tr is implicitly oriented towards the root. If the edge (u, v) is oriented from u to v, we call v the father of u on tr.

The key decision design is inspired from the following observation: Given a rooted tree tr whose root is t, the path from a given node s to t on tr is unique. An update of tr will generate a new rooted tree which may induce a new path from s to t on this tree.

Given an undirected graph g and a node r ∈ V(g), *VarRootedSpanningTree*(g,r) (also called rooted spanning tree variable) is a concept representing a dynamic spanning tree of g. The spanning tree is rooted at r.

In order to model a COP problem in an undirected graph g in which the source and the target of the desired path are respectively s,t ∈ V(g), we use *VarRootedSpanningTree*(g,s,t) which is *VarRootedSpanningTree*(g,t) with a node s designated as the source node. Each instance tr of *VarRootedSpanningTree*(g,s,t) specifies a unique path from s to t on g. Henceforth we use s to denote the source node of any rooted spanning tree of the given graph and the path from s to the root of a rooted spanning tree tr on tr is called the path induced by tr if there is no ambiguity.

The main avantage of using rooted spanning tree for modeling paths instead of using explicit paths representation (i.e. a sequence of nodes) is the simplification of neighborhood computation. The tree structure constains rich information that induces directly path structure from a node s to the root. A
simple update over that tree (i.e. an edge replacement which is detailed in Section 3) will induce a new path from s to the root.

## 3 Neighborhood

Given an instance tr of *VarRootedSpanningTree*(g,s,t), we show how to change tr in order to generate a new rooted spanning tree tr0 of g which induces a new path from s to t on g.

Given an undirected graph g, an instance tr of *VarRootedSpanningTree*(g,s,t), an edge e = (u, v)
such that e ∈ E(g) \ E(tr) is called *replacing* edge of tr. We denote rpl(tr) the set of *replacing* edges of tr. Given e ∈ rpl(tr), an edge e 0that belongs to the path between two endpoints of e on tr is called replacable edge of e. We denote rpl(tr, e) the set of *replacable* edges of e. Intuitionally, a *replacing* edge e is an edge that is not in the tree tr but that can be added to tr (this edge insertion creates a cycle C when we ignore orientations of edges of tr), and all edges of this cycle except e are *replacable* edges of e.

Given an undirected graph g, an instance tr of *VarRootedSpanningTree*(g,s,t), e and e 0are respectively *replacing* edge of tr and *replacable* edge of e, we define the following edge replacement action:
1. Insert the edge e = (u, v) to tr. This creates an undirected graph g with a cycle C containing the edge e 0.

2. Remove e 0from g.

After taking above edge replacement action, we obtain a new rooted spaning tree tr0 of g. We denote tr0 = rep(tr, e 0, e). The neighborhood of tr is N(tr) = {tr0 = rep(tr, e 0, e) | e ∈ rpl(tr), e 0 ∈ rpl(tr, e)}
It is easy to observe that two different spanning trees tr1 and tr2 rooted at t of an undirected graph g may induce the same path from s to t on g (s,t ∈ V(g)). The neighborhood N(tr) must then be reduced