void stateModel{
1. LSGraphSolver ls();
2. VarRootedSpanningTree tr[i in 1..k](ls,g,s[i],t[i]);
3. PathEdgeDisjoint ed(tr);
4. ls.close();
5.}

## Figure 4: The Modeling For The Edp Problem

from sito ti on G (< si,ti >∈ T). In [7], a Multi-start Simple Greedy algorithm is presented as well as an ACO algorithm. The ACO is known to be state-of-the-art for this problem. We propose a local search algorithm using the modeling approach. The model is given in Figure 4 where line 2 initializes an array of k VarRootedSpanningTrees representing k paths between commodities. The edge-disjoint constraint ed is which is defined over paths from s[i] to t[i] on tr[i] (i = 1, 2, ..., k) stated in line 3. In [7], the following criterion is introduced which quantifies the degree of non-disjointness of a solution S = {P1,P2*,...*Pk} (Pjis a path from sjto tj):

$$C(S)=\sum_{e\in E}(m a x\{0,\sum_{P_{j}\in S}\rho^{j}(S,e)-1\})$$

where ρ j(S, e) = 1, if e ∈ Pj ∈ S and ρ j(S, e) = 0, otherwise.

The number of violations of the PathEdgeDis joint(P1,P2*,...,*Pk) constraint in the framework is defined to be C({P1,P2*,...,*Pk}) and the proposed local search algorithm tries to minimize this criterion.

From a solution which is normally a set of k non-disjoint, a feasible solution to the EDP problem can be extracted by iteratively removing the path which has most edges in common with other paths until all remaining paths are mutually edge-disjoint as suggested in [7]. In our local search model, we extend that idea by taking a simple greedy algorithm over the remaining paths after that extraction procedure in hope of improving the number of edge-disjoint paths.

The main idea for the search is to try different moves to get a first improvement: 1-move or 2-move over one VarRootedSpanningTree, two 1-moves at hand over two VarRootedSpanningTrees.

For the experimentation, we re-implemented in COMET the Multi-start Greedy Algorithm (MSGA)
and the ACO (the extended version) algorithm which are described in [7], and compare them with our local search model. The instances experimented (graphs including commodities) in the original paper [7] is not available at the moment (except some graphs). We base on the instances generation description in the paper [7] and generate new instances as follows. We take 4 graphs from [7]. For each graph, we generate randomly different sets of commodities with different sizes depending on the size of the graph: for each graph of size n, we generate randomly 20 instances with 0.10*n, 0.25*n and 0.40*n commodities. In total, we have 240 problems instances. Due to the huge complexity of the problem, we execute each problem instance once with a time limit of 30 minutes for each execution. Experimental results are shown in Table 1. The time window for the MSGA and the ACO algorithms are also 30 minutes. The Table reports the average values of the objective function of the best solutions found and the average of times for obtaining these best solutions of 20 instances (a graph G = (V,E) and a set of r ∗|V| commodities, r = 0.10,0.25,0.40). The Table shows that our local search model gives competitive results in comparison with the MSGA and the ACO algorithms. In comparison with the MSGA, our local search model find better solutions in 217/240 instances while the MSGA find better solutions in 4/240