work are as follows. They have (at least initially) static lists of alternative routes to pick from for each flight and do not consider changing the time plans, whereas we currently only dynamically modify time plans. Their sector workload constraints limit the average number of flights in a sector over a given time interval (like our demand) but also the number of PIPs. No multi-sector planning is performed to reduce and re-balance the workloads of contiguous sectors. However, a notion of airline equity is introduced toward a collaborative decision-making process between the FAA and the airlines.

Finally, there is related work on minimising costs when holding flights (on the ground or in the air),
if not re-routing them, in the face of dynamically changing weather conditions [3]. The main differences with our work are as follows. Their objective is cost reduction for airlines and airports, whereas our work is airspace oriented. They consider ground holding and air holding, whereas we currently only consider ground holding. Their dynamic re-routing is on the projected two-dimensional plane, whereas we do not re-route yet. Their sector workload constraints limit the number of flights in a sector at any given time
(this is called sector *load* below), but there is no multi-sector planning.

A lot of related work is about dealing with potentially interacting pairs (PIPs) of flights (see [1, 7]
for instance). However, this is an operational issue, whereas our work is at the tactical level, so we do not have to worry about the number of PIPs in the modified flight plans and hence we do not enforce any aircraft separation constraints.

As this brief overview of related work shows, the whole problem of optimal airspace and airport usage by the airlines is very complex, and only facets thereof are being explored in each project. Our work intends to reveal some new facets, such as multi-sector planning.

Future work. At present, this work is only a feasibility study, and this induced some simplifications in our experiments. For instance, the cells in our grid should have different capacities (rather than the uniform 40 we experimented with), just like the current sectors, which have roughly the same traffic volumes. Indeed, demand balancing under equal capacities does not make much sense, witness for instance low-level cells in areas without airports. However, our model can now be used to fine-tune the individual cell capacities.

We must add side constraints to the current trunk of only capacity constraints in order to make things more realistic. For instance, since the re-planning happens for a time interval in the future, constraints will be needed to make sure no unacceptable traffic demand is generated *before* that interval. Additional constraints are also needed to make sure that the flight plan modifications can be implemented sufficiently quickly and cheaply, and that doing so is still offset by the resulting demand reductions and re-balancing among cells. For instance, the number of flights affected by the changes may have to be kept under a given threshold. This is where airlines and pilots will probably have to be factored in.

Our constraint model does not enforce any notion of first-planned-first-served, which is a goal for CFMU and the FAA, since the delays would then become very huge. We will investigate situations where such a fairness notion can be applied nevertheless.

Capacity (the maximum number of hourly flights that may enter a portion of airspace) is not the only metric we can enforce (under a given time step). Another common ATM metric is *load*, namely the maximum number of flights that can be simultaneously present in the portion of airspace. In a previous study [5], it was concluded that load constraints lead to less total delay than capacity constraints.

Ultimately, a *workload* metric should be used (as in our [6]), estimating the traffic complexity as it is perceived by air-traffic controllers.

Many other forms of flight re-planning can be imagined beyond the ground holding we here experimented with, such as the vertical re-routing of flights along the planned 2D route, the horizontal 2D