that often do not follow national boundaries). For each sector, a pair of *air-traffic controllers* (ATCo)
try to ensure the sector capacity and aircraft separation constraints, at the operational level, and without necessarily physically being at the ATCC headquarters. For instance, the three BeNeLux countries and small bordering parts of Germany, France, and the North Sea are covered by the Maastricht ATCC in the Netherlands, whose airspace is partitioned into about 5 or 6 sectors at every layer, with 2 or 3 layers from the ground to upper airspace.

Because of this fragmented mode of operation, the capacity of an ATCC is limited by its sector with the smallest capacity, the *capacity* of a sector being defined as the maximum hourly number of flights that may enter it. Indeed, the total capacity of an ATCC could be raised by an early identification of the traffic bottleneck areas and a redoing of the flight plans such that the traffic demand is more evenly balanced between its sectors. This has triggered the investigation of concepts dealing with multi-sector planning, where tools are developed to predict the traffic demand over several sectors and to manage the overall demand by anticipating peaks and proposing alternate plans.

Furthermore, a long-term goal is to abandon the existing sectors and reorganise the entire airspace of the *European Civil Aviation Conference* (ECAC) by starting from a three-dimensional grid of same-sized box-shaped *cells* laid over the whole European continent and some nearby countries. For instance, in our experiments, using a grid of cells whose dimensions are 75 nm × 75 nm × 125 FL,1 we have 4 layers with a total of 4600 ECAC cells, whose capacities are initially uniformly set to 40 entering flights per hour, to be enforced with a time step of 5 minutes.

## 1.2 Dynamic Demand-Capacity Balancing

This paper presents the first results on *dynamic demand-capacity balancing* at ECAC level, that is the dynamic modification of ECAC flight plans so as to satisfy the capacity constraints of all cells over a given time interval at minimal cost, thereby avoiding intolerable peaks of demand (and hence ATCo workload), as well as to balance the demands on all cells, thereby avoiding unacceptable dips of demand and unfair discrepancies between demands on the cells. There are many ways of modifying flight plans and defining the cost of such changes, and we postpone that discussion for a paragraph, so as not to disturb the presentation of the general objective. We are here only interested in aircraft that follow planned routes, rather than performing free flight.

The tactical rolling-horizon scenario considered is as follows. At a given moment, suitably called now below, the (possibly human) demand-capacity manager queries the predicted traffic demands under the given flight plans for the cells of the entire ECAC airspace over a time interval that is some 30 to 60 minutes long and starts some 3 hours after now. A look-ahead much below 3 hours would not give enough time for the implementation of some of the necessary re-planning. A look-ahead much beyond 3 hours would incur too much uncertainty in trajectory prediction (due to unpredictable weather conditions, say), and hence in demand prediction. If there are demand peaks, dips, or discrepancies that warrant interference, then the demand-capacity manager launches a re-planning process that suitably modifies the current flight plans. This process is to be repeated around the clock. For this to work, the time spent on re-planning should be very short, and the implementation effort of the modified plan should be offset by the resulting demand reductions and re-balancing among the cells.

We now come to the announced discussion of how flight plans can be modified and how the cost of such changes can be defined. In this paper, we only consider *ground holding*, that is the changing of the take-off time of a not yet airborne flight, with the rest of its plan shifted forward accordingly. For 11 nautical mile = 1.852 km = 1.15 miles; 1 flight level = 30.48 m = 100 feet.