
## 2.2 Pre-Processing

The pre-processing derives a few sets from the flight plans in order to express our constraint model and restrict search to only those flights and cells that are affected by the time interval [s*,...,* e] for re-planning:
- *Relevant Flights* is the set of flights that are planned to depart / enter by the end e of the last sliding window and to arrive / exit upon the beginning s−w of the first sliding window, as otherwise they cannot be airborne in any sliding window of the interval for re-planning (see Figure 1 again):

## Rf = { F ∈ F | Df ≤ E & Af ≥ S−W}

Note that the flights that can be ground-held so as to be airborne in some sliding window of the interval for re-planning need not be considered relevant, as they could only worsen the demands on the cells and as the objective of minimising the total amount of ground holding should set their ground holding to zero anyway.

- *Relevant Airborne Flights* is the set of relevant flights that were planned to depart / enter by now and can thus not be ground-held:
RAF = { f ∈ RF | df ≤ now}

- *Relevant Waiting Flights* is the set of relevant flights that are planned to depart / enter after now and are thus the only ones that can be ground-held:
RWF = { f ∈ RF | df > now}
- *Sliding Window Scheduled Flights* is the set of relevant waiting flights planned to contribute demand during a given sliding window Sr (where 0 ≤ r ≤ m):
SFr = { f ∈ RWF | c ∈ Cf & ef,c ∈ Sr}

- *Sliding Window Potential Flights* is the set of relevant waiting flights that can be ground-held in order to contribute demand during a given sliding window Sr (where 0 ≤ r ≤ m):
PFr = { f ∈ RWF | c ∈ Cf & s−w+r·t −g ≤ ef,c ≤ s−w+r·t}
- *Relevant Cells* is the set of cells containing some possibly ground-held relevant waiting flight in some sliding window:
RC = {c ∈ Cf| f ∈ RWF & s−w−g ≤ ef,c ≤ e}
Let P be a 2d array such that P[r, c] is initialised during the pre-processing phase to be the *known* part of the demand on relevant cell c during sliding window Sr, that is the number of relevant *airborne* flights that are inside c during Sr. The *unknown* part of that demand depends on the amount of ground holding imposed on the relevant *waiting* flights.

## 2.3 The Decision Variables And The Initial Assignment

Let *deltaT* be a 1d array of decision variables in the integer domain [0*,...,*g], such that *deltaT*[ f ] is the time delay (duration of ground holding) for the relevant waiting flight f . All delays are set to 0 in the initial assignment, as we want to ground-hold as few flights as possible.