
## 2.5 The Objective Function

The capacity constraints are considered soft during the search (in the sense that they may be violated by moves), hence the objective function must take both flight delays and constraint violations into account in order to ensure that the solution has minimum cost. The objective function to be minimised can be defined with weighted terms as follows:

$w\cdot\sum_{f\in RWF}deltaT[f]+v\cdot violations(\text{constraints}(2))$
$$({\mathfrak{I}})$$
deltaT[ f ] +v · *violations*(constraints (2)) (3)
where w and v are dynamically changing integer weights, both initially 1 and maintained by the search procedure (see Section 2.6) to minimise the sum of the delays. When the objective function cannot be improved, the values of the weights will be increased linearly. After finding the first solution, the diversification increases the violations and decreases the sum of the delays, so the balance between these weights must be reset to the initial values.

In case we also want to re-balance the demands on the cells, we have to add a weighted term to the objective function (3), namely w 0·(σc∈RC, 0≤r≤m*demand*[c,r])
where w 0is an integer weight, *demand*[c,r] is the number of flights entering cell c during sliding window Sr under the currently chosen delays, and σi∈T h(i) denotes the standard deviation of the expressions h(i)
as i ranges over the set T. In first approximation, we will always have w·w 0 = 0, that is we will minimise only one of these terms of the objective function.

## 2.6 The Search Procedure And Heuristics

We here only give a heuristic and meta-heuristic for minimising the total ground holding (when w 6=
0 & w 0 = 0). Different (meta-)heuristics may have to be designed for (simultaneous) demand balancing
(when w 0 6= 0).

The search procedure consists of a multi-state heuristic and a meta-heuristic. An event-based tabu search is used together with an exponential diversification in order to escape local minima during the constraint satisfaction phase, as well as an intensification in order to improve the objective function after the satisfaction phase as the meta heuristic. We devised a heuristic with three states, and the search procedure may switch states while making moves. This heuristic is quite involved, but it gives better results than the other approaches we tried, including satisfaction with generic tabu search, variable neighbourhood search, variable-depth neighbourhood search, and weighted optimisation. Among these approaches, only satisfaction with generic tabu search was faster; however it could not minimise the objective function better than our three-state heuristic. Hence we now discuss only the latter.

As mentioned in Section 2, an optimal solution must satisfy all the constraints and minimise the sum of all delays. *Furthermore*, an optimal solution is expected to have a maximum of flights with a zero delay, and the percentage of flights with a given delay is expected to decrease as the delay increases. Indeed, previous studies as well as discussions with CFMU and aircraft operators have shown that it is preferable to have many flights with short delays than a few flights with long delays of the same sum. In our heuristic, we make use of this feature to narrow down the neighbourhood by first selecting a delay d in the domain [0*,...,*g] and then looking for the flight f that achieves the largest violation decrease if deltaT[ f ] is assigned d. The selection process of d cannot be random: it should follow the exponential probability to force the variables to fit best into the expected solution.