
| Instance       | #instances   | #variables   | #clauses   |
|----------------|--------------|--------------|------------|
| aim−50−no−1 6  | 4            | 50           | 80         |
| aim−50−no−2 0  | 4            | 50           | 100        |
| aim−100−no−1 6 | 4            | 100          | 160        |
| aim−100−no−2 0 | 4            | 100          | 200        |
| aim−200−no−1 6 | 4            | 200          | 320        |
| aim−200−no−2 0 | 4            | 200          | 400        |
| uu f 50−218    | 100          | 50           | 218        |

generate. The generator runs in a randomized fashion, so that it is essentially different from those generated deterministically, or those translated from other problems such as graph colouring. We utilized three sets of unsatisfiable aim problem instances. Each set has either 50, 100 or 200 variables, and within each set we have two groups: four instances where the ratio clause/variable is 1.6, and another group of four instances for which the ratio is 2.

- The uuf50-218 benchmark consists of unsatisfiable uniform random 3-SAT instances. For an instance with n variables and k clauses, each of the k clauses has three literals which are randomly picked from the 2n possible literals (the n variables and their negations) such that each possible literal is selected with the same probability. Clauses are discarded either if they contain repeated literals or a literal and its negation (i.e. tautologous clauses). We considered the data set of 100 unsatisfiable instances with 50 variables and 218 clauses, dubbed data set uuf50-218.
Table 5 illustrates the characteristics of each set of problem instances, providing for each of them the number of instances, variables and clauses.

We used the CPU time (in seconds) that each instance requires to be solved by a given tool as a measure of performance, as well as the number of iterations it takes to solve the instance. To better illustrate the usefulness of each component added to RANGER, each problem instance was run with different versions of RANGER: the original RANGER code as a basis for comparisons (Original); RANGER with unit propagation look-ahead (UPLA); and RANGER with both unit propagation look-ahead and extended resolution (UPLA+ER). Results for GUNSAT were also collected.

The results were obtained in an Intel Xeon 5160 server (3.0GHz, 1333Mhz, 4GB) running Red Hat Enterprise Linux WS 4. Each problem instance was given a timeout of 1000 seconds. Results for each instance were obtained from 10 runs using 10 different seeds.

Tables 5, 5 and 5 show the results of, respectively, the percentage of instances solved, the CPU time taken to solve each set of instances and the median number of iterations performed by each solver (only taking into account the successful runs). The CPU time reported was computed as follows: first, for each instance was considered the mean time of the successful runs; second, the average of the given results for each instance in a set of instances was computed. The number of iterations are not reported for GUNSAT
given that such information is not provided by the tool.

From these tables, we conclude that the best solver for solving easier instances with few variables and a low ratio of variables/clauses is the original RANGER due to its simplicity. For all the other instances of the aim family, RANGER with unit propagation look-ahead beats the other two RANGER variants in terms of percentage of instances solved, required time and number of iterations, and is comparable with GUNSAT. For the uuf50-218 set of instances, GUNSAT is far superior to RANGER in any of its forms.