practice, e ⇔ l1 ∨l2 is encoded by the three clauses (¬e∨l1 ∨l2), (e∨ ¬l1) and (e∨ ¬l2).

Look-ahead techniques are used to detect equivalences between literals until an inconsistency is found. GUNSAT uses look-ahead unit propagation on pairs of literals, such that the four possible pairs of values are propagated in ϕ, potentially implying more propagations.

## 3.3 Ranger Vs. Gunsat

There are some few important differences between these two local search algorithms for proving unsatisfiability. RANGER generates a large number of the shortest possible clauses as fast as possible, using unintelligent local moves, whereas GUNSAT takes longer to make more intelligent moves based on a more complex objective function. GUNSAT also uses higher reasoning techniques like extended resolution and unit propagation look-ahead (RANGER uses only general resolution). Also, unlike GUNSAT,
RANGER uses a mechanism to ensure bounded memory.

## 4 Improving Ranger

This section describes the implementation of unit propagation look-ahead and extended resolution in RANGER. We should note that before starting to implement new features into the solver we made a series of modifications to the original tool in terms of data structures to better accommodate our needs. For the new techniques, it is required to have a complete knowledge of a clause status, namely to identify whether it is satisfied, unsatisfied or unresolved, in which case is important to distinguish unit clauses.

## 4.1 Implementing Unit Propagation Look-Ahead

The solver GUNSAT successfully uses a method dubbed unit propagation look-ahead [2] to improve its basic algorithm. The literals of the formula under consideration are extensively checked to see if there are any conflicts arising from hypothetical assignments.

GUNSAT implements a version of the unit propagation look-ahead which uses two variables. These two variables are then assigned a value such that the four possible combinations are covered. If ν1 and ν2 are our variables, then the four possible combinations are: (1) ν1 = 0 and ν2 = 0, (2) ν1 = 0 and ν2 = 1,
(3) ν1 = 1 and ν2 = 0, and (4) ν1 = 1 and ν2 = 1.

Given an assignment to a pair of variables, a *conflict* is identified when one of the clauses becomes unsatisfied as a result of unit propagation. For each iteration of this look-ahead method, i.e., for each combination of variable assignments, we store the value of each variable in the formula, only if that variable is forced to be assigned as a result of unit propagation (note that these assignments are only temporary, done for each iteration of the look-ahead and stored only for the duration of the look-ahead for the two variables). But in RANGER we have further extended this technique.

Let us consider the assignments which were implied by unit propagation after assigning a pair of variables. We may further consider *intersections* of implications when taking into account different assignments made to the variables in that pair. We should now focus on the number of conflicts after the application of the unit propagation look-ahead technique after assigning a pair of variables. In the worst case, we may end up with four conflicts, one for each of the four different assignments for a given pair of variables. (Note that the method to be applied resembles the Stalmark's method [21] and has been ¨
applied to CNF formulas in the past [13].) Overall, we have five possible scenarios: