- **Zero conflicts**: If there are no conflicts, we will consider all four combinations when computing the intersection. If a variable is assigned the same value through all combinations, then that value will be assigned and the unit clause rule will be applied.

- **One conflict**:
- The intersections will be calculated, but now only considering the combinations that did not yield a conflict (three in this case). Again, if a variable is assigned the same value through the three combinations, then that value will be assigned and the unit clause rule will be applied.

- A binary clause is added to the formula: this clause results from the negation of the assignments that yield a conflict.

## - **Two Conflicts**:

- As above, the intersections will be calculated, but only considering the combinations that did not yield a conflict (two in this case). This may result in new unit clauses.

- Two binary clauses are added to the formula, resulting each one from the negation of the assignments that yield a conflict. There is a special case where only one unit clause is added, which happens when a variable assignment is repeated in both conflicts (the two binary clauses are resolved to generate the unit clause).

- **Three conflicts**:
- The values that were assigned in the only combination that did not yield a conflict will be propagated as a result of the two unit clauses being added, each one with each the variable assignment that did not yield a conflict.

- **Four conflicts**: The formula yields a conflict for all combinations, which means that the formula is unsatisfiable.
Example 1 *To illustrate the look-ahead behaviour of* GUNSAT *suppose we have the following formula* ϕ *with the clauses:*
c1 = (ν1 ∨ν2 ∨ν3)
c2 = (ν1 ∨ ¬ν2 ∨ν3)
c3 = (¬ν1 ∨ν3)
c4 = (ν3 ∨ ¬ν4)
Clearly, for any of the possible assignments to ν1 and ν2 the value of ν3 must be 1. Thus, we have that ν3 must be assigned value 1, regardless of the assignments made to other variables, and the clause c5 = (ν3) *can be added to the formula as a unit clause. We can then perform unit propagation.*
Example 2 *The unit propagation look-ahead can also be used to derive an empty clause. Suppose we* have the following formula ϕ:
c1 = (ν1 ∨ν2)
c2 = (¬ν1 ∨ν2)
c3 = (¬ν2 ∨ν3)
c4 = (¬ν2 ∨ ¬ν3)
If we consider ν2 = 1, then either clause c3 or c4 becomes unsatisfied. On the other hand, if we consider ν2 = 0, then either clause c1 or c2 becomes unsatisfied. Therefore, there is no assignments to variable ν1 to make the formula satisfied and as such we conclude that it is unsatisfiable. (In this case, there was no need to consider pairs of assignments to reach such a conclusion.)