# Integrating Conflict Driven Clause Learning To Local Search

Gilles Audemard Jean-Marie Lagniez Bertrand Mazure Lakhdar Sa¨ıs
∗
Universit´e Lille-Nord de France CRIL - CNRS UMR 8188 Artois, F-62307 Lens
{audemard,lagniez,mazure,sais}@cril.fr This article introduces SATHYS (*SAT HYbrid Solver*), a novel hybrid approach for propositional satisfiability. It combines local search and conflict driven clause learning (CDCL) scheme. Each time the local search part reaches a local minimum, the CDCL is launched. For SAT problems it behaves like a tabu list, whereas for UNSAT ones, the CDCL part tries to focus on minimum unsatisfiable sub-formula (MUS). Experimental results show good performances on many classes of SAT instances from the last SAT competitions.

## 1 Introduction

The SAT problem, namely the issue of checking whether a set of Boolean clauses is satisfiable or not, is a central issue in many computer science and artificial intelligence domains, like theorem proving, planning, non-monotonic reasoning, VLSI correctness checking. These last two decades, many approaches have been proposed to solve large SAT instances, based on logically complete or incomplete algorithms. Both local-search techniques [29, 28, 18] and elaborate variants of the Davis-Putnam-LovelandLogemann DPLL procedure [6] [27, 8], called modern SAT solvers, can now solve many families of hard SAT instances. These two kinds of approaches present complementary features and performances. Modern SAT solvers are particularly efficient on the industrial SAT category while local search performs better on random SAT instances.

Consequently, combining stochastic local search (SLS) and conflict driven clause learning (CDCL)
solvers seems promising. Note that it was pointed as a challenge by Selman *et al.* [30] in 1997. Such methods should exploit the quality and differences of both approaches. Furthermore, the perfect hybrid method has to outperform both local search and CDCL solvers. A lot of attempts have been done last decade [4]. These different attempts will be discussed in section 3.

In this paper, we propose another hybridization of local search and modern SAT solver, named SATHYS (*SAT HYbrid Solver*). The local search solver is the main one. Each time it reaches a local minimum, the CDCL part is called and assigns some variables. This part of our solver is expected to have different behaviours depending on the kind of formula to solve. In case of a satisfiable one, the CDCL part can be seen as a tabu list [12] in order to protect good variables and avoid to reach the same minimum quickly. On the other hand, for unsatisfiable formulas, it tries to focus the search on minimum unsatisfiable sub-formulas (MUS) [9, 14, 15], allowing to concentrate on a small part of the whole formula. Like this, the CDCL component of SATHYS is used as a strategy to escape from local minimum.

The rest of the paper is organized as follows. Section 2 introduces different notions necessary for understanding the rest of the paper. Section 3 discusses different hybrid methods. Section 4 gives the 