
## 3.1 Fixed Length Sliding Window As The Neighborhood

In all the constraints listed in section 2.1, the only constraint imposed on the columns is the coverage

![0_image_0.png](0_image_0.png)

![0_image_1.png](0_image_1.png) constraint cardinality. In our first strategy, we simply set the total number of nurses as the size of rows in the fragment. Based on the domain knowledge that most pattern and sequence related constraints concern one week length, i.e. full-time nurses work 4 or 5 shifts per week and part-time nurses work 2 or 3 shifts per week, etc, we set the length of rows in the fragment as 7 (days), as shown in Fig 1. This iterative selection of fragments can be seen as a sliding window with a fixed length over the roster in each iteration of the LNS loop. This is a basic and static strategy in choosing the fragment to relax and re-optimize in the LNS scheme.

## 3.2 Sliding Window With An Overlap As The Neighborhood

Due to the row constraints concerning shift patterns and sequences, optimizing only the variables within the fixed length sliding window usually leads to violations of constraints over the variables on the boundary of these windows, as the row constraints upon the variables over the boundary interleave with the variables outside of the window. For example, as shown in Fig 2, if we relax and re-optimize the variables within the sliding window while freezing all variables outside of the window, the shift sequence of NNN for nurse H will be seen as violating the constraint of length of consecutive night shifts. In strategy 2, we consider the overlap between these sliding windows, i.e. adding the variables over the boundaries into the fragment by including different number of related variables which are involved in those constraints over the boundary.

## 3.3 Regions Of Low Quality Detected By Cost Of Soft Constraints

As mentioned above, the success of LNS depends on the adequacy of neighbourhood defined with regard to the problematic part of the solution assignment and the choice of neighbourhood size. In the first two strategies, the fragment (neighborhood) is set as is set as the length of one week (columns) for all number of nurses (rows). These are efficient strategies when the problem is small, i.e. with 8 or 10 nurses. However, as the solution space increases for large problems, the computational time to re-optimize the fragment is more expensive. In strategy 3, q rows of manageable size and of low quality in the roster are detected based on the cost p(c) of soft constraint c. The number of rows q is a thus parameter here. For