
## 3.4 Local Search

We have proposed a new algorithm called DMN2 which proved to be efficient on both problems. It is a variant of the Diversification by Multiple Neighborhood (DMN) proposed in [2]. DMN is based on Tabu Search, and adds a mechanism to perform diversification when the search is going round and round without improving the objective (eventhough it is not a local minimum). This replaces the classical random restart steps. We refine this particular mechanism by proposing several ways of escaping such areas.

More precisely, on our problems, after a series of consecutive non improving iterations, the DMN
algorithm empties a partition by moving all its items to another partition, disregarding the capacity constraint and locally minimizing the objective function. There is a particular case for our function z5, because it integrates the capacity constraints. In this case, the "z5" version of DMN we have implemented moves the items to another partition minimizing z5. The results in [2] show a general trend on SRAP and IDP: the more diversification is performed, the better are the results. Following this idea, we propose different ways of perfoming the DMN step, which gives our algorithm DMN2. In DMN2, when the search needs to be diversified, it randomly chooses among three diversification methods (d1,d2,d3). The first method, d1, is the diversification used in DMN. The second one, d2, generates a random solution, in the same way as a classic random restart. Finally, d3 randomly chooses a number m in the range [1, k],
where k is the number of rings, and applies m random moves.

In the end, our general algorithm starts with a solution where all the items are in the same partition.

Then it applies one of the local search algorithms described before. If the solution returned by the local search is feasible but with the objective value greater than the lower bound klb, it empties one partition by randomly assigning all its items to another. Then run once again the local search until it founds a solution with the objective value equals to klb or until the time limit is exceeded.

## 4 Results

The objective functions and the metaheuristics, respectively described in Section 3.3 and Section 3.4, have been coded in COMET and tested on Intel based, dual-core, dual processor, Dell Poweredge 1855 blade server, running under Linux. The instances used are from the litterature.

## 4.1 Benchmark

To test the algorithms, we used two sets of instances. The first one has been introduced in [6]. They have generated 80 *geometric* instances, based on the fact that customers tend to communicate more with their close neighbors, and 80 *random* instances. These subsets have both 40 *low-demand* instances, with a ring capacity B = 155 Mbs, and 40 *high-demand* instances, where B = 622 Mbs. The traffic demand between two customers, u and v, is determined by a discrete uniform random variable corresponding to the number of T1 lines required for the anticipated volume of traffic between u and v. A T1 line has an approximate capacity of 1.5 Mbs. The number of T1 lines is randomly picked in the interval [3,7], for low-demand cases, while it is selected from the range [11,17], for the high-demand cases. The generated graphs have |V*| ∈ {*15,25,30,50}. In the 160 instances, generated by O. Goldschmidt, A. Laugier and E. Olinick in 2003, 42 have been proven to be unfeasible by R. Aringhieri and M. Dell'Amico using CPLEX 8.0 (see [2]).