
| size   | time    | speedup with k SPUs   | time   |      |      |         |       |
|--------|---------|-----------------------|--------|------|------|---------|-------|
| 1 SPU  | 2       | 4                     | 8      | 12   | 16   | 16 SPUs |       |
| 30     | 0.855   | 2.2                   | 3.3    | 4.4  | 5.9  | 6.9     | 0.125 |
| 40     | 2.496   | 2.0                   | 3.6    | 5.7  | 6.1  | 7.4     | 0.335 |
| 50     | 3.903   | 1.8                   | 2.5    | 3.8  | 5.2  | 5.6     | 0.702 |
| 60     | 9.834   | 2.2                   | 3.8    | 5.6  | 7.2  | 6.8     | 1.441 |
| 70     | 17.571  | 2.2                   | 3.4    | 4.8  | 6.6  | 8.5     | 2.065 |
| 80     | 31.889  | 3.0                   | 4.3    | 5.8  | 7.6  | 8.6     | 3.689 |
| 90     | 57.746  | 2.9                   | 3.8    | 7.2  | 9.3  | 10.8    | 5.323 |
| 100    | 189.957 | 5.9                   | 9.3    | 13.9 | 21.9 | 22.6    | 8.387 |

systems such as GNU-Prolog or ILOG Solver perform poorly on this benchmark and cannot solve instances greater than 10×10. On the other hand AS/Cell is able to solve 100×100 in only few seconds with 16 SPUs. Table 9 details the largest instance both for the average case and the worst case with associated speedups. For this example the speedups are super-linear: with 16 SPUs the average time is divided by 22 while the worst case is divided by 500!

| #SPUs      | average case   | worst case   |          |       |
|------------|----------------|--------------|----------|-------|
| time (sec) | speedup        | time (sec)   | speedup  |       |
| 1          | 189.957        | 1.0          | 9013.330 | 1.0   |
| 2          | 31.975         | 5.9          | 143.270  | 62.9  |
| 4          | 20.532         | 9.3          | 59.170   | 152.3 |
| 8          | 13.686         | 13.9         | 58.350   | 154.5 |
| 12         | 8.677          | 21.9         | 16.860   | 534.6 |
| 16         | 8.387          | 22.6         | 17.830   | 505.5 |

## 6 Analysis: Performance And Robustness

The performance evaluation of section 5 has shown that the Adaptive Search method is a good match for the Cell/BE architecture. This processor is clearly a serious candidate to effectively solve highly combinatorial problems. All problems tested were accelerated when using several SPUs. For 3 of the problems the ultimate speedup obtained with 16 SPUs seems constant whatever the size of the problem which is very promising. Moreover, for magic squares the speedup tends to increase as the problem becomes more difficult which is also a very interesting property.

This evaluation has also uncovered an even more significant improvment on the worst case: the obtained speedup is always better than the one obtained in the average case. Like this, AS/Cell greatly narrows the range of possible execution times for a given problem. Figure 3 depicts the graph of the 50 executions for the all-interval 450 benchmark, both with 1 and 16 SPUs (due to space limitation we only show this one but a similar graph exists for all other problems). This graph clearly reveals the