architectures [13], using a hierarchical shared memory and trying to minimize communication between clusters. While moving from traditional SMP machines to multi-core systems is a relatively straightforward change, it is not necessarily so for more exotic architectures, such as the hetherogeneous multicore chips which include the Cell/BE.

For Constraint Satisfaction Problems, early work has been done in the context of Distributed Artificial Intelligence and multi-agent systems, see for instance [18], but these methods, even if interesting from a theoretical point of view, cannot lead to efficient algorithms and cannot compete with good sequential implementations. Moreover, the focus is usually not on performance but on the formulating a problem in a distributed fashion. Only very few implementations of efficient constraint solvers on parallel machines have been reported, most notably [14], which again is aimed at shared-memory architectures and recently
[11] which proposes a distribted extendion of the Comet local search solver for clusters of PCs.

## 3 The Adaptive Search Algorithm

Over the last decade, the application of local search techniques for constraint solving in general (and not only for combinatorial optimization) has started to draw some interest in the CSP community. A generic, domain-independent local search method named Adaptive Search was proposed by [4, 5], a new metaheuristic that takes advantage of the structure of the problem in terms of constraints and variables and can guide the search more precisely than a global cost function to optimize (such as for instance the number of violated constraints). The algorithm also uses an short-term adaptive memory in the spirit of Tabu Search in order to prevent stagnation in local minima and loops. This method is generic, can be applied to a large class of constraints (e.g. linear and non-linear arithmetic constraints, symbolic constraints, etc) and naturally copes with over-constrained problems. The input of the method is a problem in CSP
format, that is, a set of variables with their (finite) domains of possible values and a set of constraints over these variables. For each constraint, an "error function" needs to be defined; it will give, for each tuple of variable values, an indication of how much the constraint is violated. For instance, the error function associated with an arithmetic constraint |X −Y| < c, for a given constant c ≥ 0, can be max(0,|X −Y|−c).

Adaptive Search relies on iterative repair, based on variable and constraint error information, seeking to reduce the error on the worst variable so far. The basic idea is to compute the error function for each constraint, then combine for each variable the errors of all constraints in which it appears, thereby projecting constraint errors onto the relevant variables. Finally, the variable with the highest error will be designated as the "culprit" and its value will be modified. In this second step, the well known minconflict heuristic [12] is used to select the value in the variable domain which is the most promising, that is, the value for which the total error in the next configuration is minimal. In order to prevent being trapped in local minima, the Adaptive Search method also includes a short-term memory mechanism to store configurations to avoid (variables can be marked Tabu and "frozen" for a number of iterations), and also integrates restart-based transitions to escape stagnation around local minima. Restarts are partial and are guided by the number of variables being marked Tabu. The core ideas of adaptive search can be summarized as follows:
- to consider for each constraint a heuristic function that is able to compute an approximated degree of satisfaction of the goals (the current "error" on the constraint);

- to aggregate constraints on each variable and project the error on variables thus trying to repair the
"worst" variable with the most promising value;
- to keep a short-term memory of bad configurations to avoid looping (i.e. some sort of "tabu list").