
## Algorithm

Consider an n-ary constraint c(X1,···Xn) and associated variable domains D1,···Dn. An error function fc associated to the constraint c is a real-valued function from D1 *× ··· ×*Dn such that fc(X1,···Xn) has value zero if c(X1,···Xn) is satisfied. The error function will in fact be used as a heuristic value to represent the degree of satisfaction of a constraint and will thus give an indication on how much the constraint is violated. This is very similar to the notion of "penalty functions" used in continuous global optimization. This error function can be seen as (an approximation of) the distance of the current configuration to the closest satisfiable region of the constraint domain. Since the error is only used to heuristically guide the search, we can use any approximation when the exact distance is difficult (or even impossible) to compute.

## Input

Problem given in CSP format:
- a set of variables V = {V1,V2*,...,*Vn} with associated domains of values - a set of constraints C = {C1,C2*,...,*Ck} with associated error functions
- a combination function to project constraint errors on variables
- a (positive) cost function to minimize Some tuning parameters: - T : Tabu tenure (number of iterations a variable is frozen)
- RL : reset limit (number of frozen variables triggering a reset)
- RP : reset percentage (percentage of variables to reset)
- Max I : maximal number of iterations before restart
- Max R : maximal number of restarts

## Output

A solution (configuration where all constraints are satisfied) if the CSP is satisfied or to a quasi-solution of minimal cost otherwise.

Algorithm Iteration = 0 Restart = 0 Repeat Restart = Restart + 1 Iteration = Iteration +1 Tabu Nb = 0 Compute a random assignment A of variables in V Opt Sol = A Opt Cost = cost(A) Repeat 1. Compute errors of all constraints in C
and combine errors on each variable
(by considering only the constraints in which a variable appears)