
## 5.1 The All-Interval Series

Although looking like a pure combinatorial search problem, this benchmark is in fact a well-known

![0_image_0.png](0_image_0.png) exercise in music composition [17]. The idea is to compose a sequence of N notes such that all are different and tonal intervals between consecutive notes are also distinct (see Figure 1).

This problem is described as prob007 in the CSPLib [6]. It is equivalent to finding a permutation of the N first integers such that the absolute difference between two consecutive pairs of numbers are all different. This amounts to finding a permutation (X1,...XN) of {0,...N −1} such that the list (abs(X1 −
X2),abs(X2 −X3)...abs(XN−1 −xN)) is a permutation of 1*,...,*N −1.

Table 1 presents the average time of 50 running (in seconds) for several instances of this benchmark together with the speedup obtained when using different number of SPUs. From this data one can conclude the speedup linearly increases with the number of SPUs to reach 11 with 16 SPUs. This factor appears to be constant whatever the size of problem.

| size   | time    | speedup with k SPUs   | time   |     |     |         |        |
|--------|---------|-----------------------|--------|-----|-----|---------|--------|
| 1 SPU  | 2       | 4                     | 8      | 12  | 16  | 16 SPUs |        |
| 100    | 1.392   | 1.6                   | 3.3    | 5.0 | 5.7 | 7.4     | 0.189  |
| 150    | 9.496   | 2.3                   | 4.4    | 6.3 | 9.0 | 10.4    | 0.910  |
| 200    | 28.165  | 1.5                   | 3.0    | 6.1 | 7.8 | 9.0     | 3.139  |
| 250    | 61.437  | 1.8                   | 3.8    | 5.1 | 6.5 | 9.8     | 6.282  |
| 300    | 147.178 | 1.7                   | 2.9    | 5.6 | 7.3 | 9.2     | 15.920 |
| 350    | 346.790 | 2.3                   | 4.4    | 5.6 | 9.6 | 12.2    | 28.359 |
| 400    | 508.819 | 1.6                   | 3.3    | 7.6 | 8.8 | 10.8    | 46.989 |
| 450    | 946.860 | 2.0                   | 4.1    | 8.7 | 9.2 | 11.0    | 85.936 |

Table 1: timings (sec) and speedups for all-interval series It is worth noticing that state-of-art constraint solvers (e.g. Gecode) are able to find the trivial solution
(0,N −1,1,N −2,2,N −3*,...*) in a reasonable amount of time but fail to find an interesting solution for N ≥ 20. The AS/Cell implementation is able to find solutions for N = 450 in 1.5 minute with 16 SPUs.

Table 2 detail this instance providing information on both the average case and the worst case (together with the associated speedups). In this problem, linear speedups are obtained: with 16 SPUs the average time is 11 times faster. When discussing worst cases, the time is divided by a factor 26.

## 5.2 Number Partitioning

This problem consists in finding a partition of numbers {1*,...*N} into two groups A and B such that:
- A and B have the same cardinality