
| #SPUs      | average case   | worst case   |          |      |
|------------|----------------|--------------|----------|------|
| time (sec) | speedup        | time (sec)   | speedup  |      |
| 1          | 946.860        | 1.0          | 4661.870 | 1.0  |
| 2          | 470.421        | 2.0          | 1912.200 | 2.4  |
| 4          | 228.294        | 4.1          | 988.220  | 4.7  |
| 8          | 109.322        | 8.7          | 304.160  | 15.3 |
| 12         | 102.831        | 9.2          | 443.550  | 10.5 |
| 16         | 85.936         | 11.0         | 177.210  | 26.3 |

- the sum of numbers in A is equal to the sum of numbers in B
- the sum of squares of numbers in A is equal to the sum of squares of numbers in B
A solution for N = 8 is A = (1,4,6,7) and B = (2,3,5,8) since:

$$\begin{array}{c}{{1+4+6+7=18=2+3+5+8}}\\ {{1^{2}+4^{2}+6^{2}+7^{2}=102=2^{2}+3^{2}+5^{2}+8^{2}}}\end{array}$$

This problem admits a solution iff N is a multiple of 8 and is modeled with N variables Vi ∈ {1...N}
which form a permutation of {1...N}. The first N/2 variables form the group A, the N/2 last variables the group B. There are two constraints:

$$\begin{array}{r c l}{{}}&{{\Sigma_{i=1}^{N/2}V_{i}\;=\;N(N+1)/4\;=\;\Sigma_{i=N/2+1}^{N}V_{i}}}\\ {{}}&{{}}&{{}}\\ {{\Sigma_{i=1}^{N/2}V_{i}^{2}\;=\;N(N+1)(2N+1)/12\;=\;\Sigma_{i=N/2+1}^{N}V_{i}^{2}}}\end{array}$$

The possible moves from one configuration consist in all possible swaps exchanging one value in the first subset with another one in the second subset. The errors on the 2 equality constraints are computed as the absolute value of the difference between the actual sum and the expected constant (e.g. N(N +1)/4).

In this problem, like for the all-intervals example, all variables play the same role and there is no need to project errors on variables. The total cost of a configuration is the sum of the absolute values of both constraint errors. A solution is found when the total cost is zero.

Table 3 details the average running times (in seconds) for several instances of this problem together with the speedup obtained when using different numbers of SPUs. Similarly to what occured with the all-interval series, the speedup increases linearly up to a factor of 11. Again, the speedup appears to be independent from the size of the problem.

Once more, it is worth noticing that Constraint Programming systems such as GNU Prolog cannot solve this problem for instances larger than 128. On the other hand the AS/Cell implementation is able to find solutions for N = 2600 in few seconds with 16 SPUs: this problem scales very well and it is possible to solve even larger instances. Table 4 details the largest instance both for the average case and the worst case (together with the associated speedups). For this example the speedups are linear: with 16 SPUs the average time is divided by 11 while the worst case is divided by 17.

## 5.3 The Perfect-Square Placement Problem

This problem is described as prob009 in CSPLib [6]. It is also called the *squared square* problem [10]
and consists in packing a set of squares into a master square in such a way that no squares overlap each