Definition 2 (Acceptance) *Given an automaton and an assignment V* = hd1,...,dni*, a segmentation* σ1,...,σℓis accepted *by the automaton if there exist strings* α1,...,αℓ+1, where only α1 and αℓ+1 may be empty, such that the concatenated string α1 ·σ1 ·α2 **· ··· ·**αℓ·σℓ·αℓ+1 is accepted by the automaton.

For example, given the automaton in Figure 1, the assignment V = hx,e,d,e,x,xi has a segmentation hx,ei,he,x,xi with ℓ = 2, which is accepted by the automaton via the string hx,e,x,e,x,xi with α1 = α3 =
ε (the empty string) and α2 = hdi.

Given an assignment, the algorithm presented below initialises and updates a segmentation. The violations of the constraint and its decision variables are calculated relative to the current segmentation:
Definition 3 (Violations) *Given an automaton describing a constraint c and given a segmentation* σ1,...,σℓ of an assignment for a sequence of n decision variables V1,...,Vn:
- The constraint violation *of c is n*−∑
ℓj=1 |σj|.

- The variable violation of decision variable Viis 0 *if there exists a segment index j in* 1,..., ℓ *such* that i ∈ σj, and 1 *otherwise.*
It can easily be seen that the violation of a constraint is also the sum of the violations of its decision variables, and that it is never an underestimate of the minimal Hamming distance between the current assignment and any satisfying assignment.

Our approach, described in the next three sub-sections, greedily grows a segmentation from left to right across the current assignment relative to a satisfying assignment, and makes stochastic choices whenever greedy growth is impossible.

## 2.2 Initialisation

A finite automaton is first unrolled for a given length n of a sequence V = hV1,...,Vni of decision variables, as in [11]:
Definition 4 (Layered Graph) *Given a finite automaton with m states, the* layered graph over a given number n of decision variables is a graph with m ·(n+1) nodes. Each of the n+1 *vertical layers has a* node for each of the m states of the automaton. The node for the start state of the automaton in layer 1 is marked as the start node. There is an arc labelled w from node f in layer i to node t in layer i+ 1 if and only if there is a transition labelled w from f to t in the automaton. A node in layer n+1 is marked as a success node if it corresponds to a success state in the automaton.

The layered graph is further processed by removing all nodes and arcs that do not lead to a success node. The resulting graph, seen as a DFA (or as an ordered MDD), need not be minimised (or reduced)
for our approach (although this is a good idea for the global search approaches [2, 11], as argued in [7],
and would be a good idea for the local search approach of [12]), as the number of arcs of the graph does not influence the time complexity of our algorithm below. For instance, the minimised unrolled version for n = 6 decision variables of the automaton in Figure 1 is given in Figure 2. Note that a satisfying assignment hd1,...,dni corresponds to a path from the start node in layer 1 to a success node in layer n+1, such that each arc from layer i to layer i+1 of this path is labelled di.

Further, we require a number of data structures, where m is the number of states in the given automaton and n is the number of decision variables it was unrolled for: