# Tracking Object'S Type Changes With Fuzzy Based Fusion Rule

Albena Tchamova, Jean Dezert and Florentin Smarandache 

## Abstract

In this paper the behavior of three combinational rules for temporal/sequential attribute data fusion for target type estimation are analyzed. The comparative analysis is based on: Dempster's fusion rule proposed in Dempster-Shafer Theory; Proportional Conflict Redistribution rule no. 5 (PCR5), proposed in Dezert-Smarandache Theory and one alternative class fusion rule, connecting the combination rules for information fusion with particular fuzzy operators, focusing on the t-norm based Conjunctive rule as an analog of the ordinary conjunctive rule and t-conorm based Disjunctive rule as an analog of the ordinary disjunctive rule. The way how different t-conorms and t-norms functions within TCN fusion rule influence over target type estimation performance is studied and estimated. 

## 1 Introduction

Target type estimates can be used during different target tracking process' stages for improving data to track association and for the quality evaluation of complicated situations characterized with closely spaced or/and crossing targets. It supports the process of identification, (e.g. friendly aircraft against hostile ones, fighter against cargo), helping that way the operator of the tracking system to initiate relevant measures. The process of identification could use many types of different attribute information, for instance, discrete information associated with ESM (Electronic Support Measures) 
data, IRST (Infra-Red Search and Track) measurements and direct target type observations. It requires also efficient fusion rules and criteria to estimate the correct associations. Our motivation for attribute fusion is inspired from the necessity to ascertain the targets' types, information, that in consequence has an important implication to enhance the tracking performance. In the literature we can find many fusion methods derived from different underlying frameworks, ranging from Bayesian probability theory ([1]), Dempster-Shafer evidence theory ([2], [3], [4]) to fuzzy sets ([5], [6], [7]) etc. In temporal multiple target tracking the main requirements we have to deal with relate especially to the way of adequate conflict processing/redistribution, the simplicity of implementation, satisfaction of the impact of neutrality of Vacuous Belief Assignment (VBA), reflection of majority opinion, etc. The choice of method ([15]) depends on the richness of abstraction and diversity of sensor data. 

The most used until now Dempster-Shafer Theory (DST) proposes a suitable mathematical framework for representation of uncertainty. It is one of the widely applied framework in the area of target 