# Finite Element Model Selection Using Particle Swarm Optimization

Linda Mthembu1, Tshilidzi Marwala2, Michael I. Friswell3, Sondipon Adhikari4 
 
1Visiting Researcher, Department of Electronic and Computer Engineering, Faculty of Engineering and Built Environment, University of Johannesburg, PO Box 17011, Doornfontein 2028, South Africa. 

 
2Executive Dean Faculty of Engineering and Built Environment, University of Johannesburg, PO Box 17011, Doornfontein, 2028, South Africa, South Africa. 

 
3Professor of Aerospace Structures, School of Engineering, Swansea University, Singleton Park, Swansea SA2 8PP, United Kingdom. 

 
4Chair of Aerospace Engineering, School of Engineering, Swansea University, Singleton Park, Swansea SA2 8PP, United Kingdom 

## Abstract

This paper proposes the application of particle swarm optimization (PSO) to the problem of finite element model (FEM) selection. This problem arises when a choice of the best model for a system has to be made from set of competing models, each developed a priori from engineering judgment. PSO is a population-based stochastic search algorithm inspired by the behaviour of biological entities in nature when they are foraging for resources. Each potentially correct model is represented as a particle that exhibits both individualistic and group behaviour. Each particle moves within the model search space looking for the best solution by updating the parameters values that define it. The most important step in the particle swarm algorithm is the method of representing models which should take into account the number, location and variables of parameters to be updated. One example structural system is used to show the applicability of PSO in finding an optimal FEM. An optimal model is defined as the model that has the least number of updated parameters and has the smallest parameter variable variation from the mean material properties. Two different objective functions are used to compare performance of the PSO algorithm. 

| Nomenclature  FEM Finite element model.  FEMU Finite element model updating.  PSO Particle Swarm Optimization.  d Model Dimension.  mid i-th Finite element model position at parameter d.  vid i-th Finite element model velocity at parameter d.  pid Best position for the ith Finite element model at parameter d.  pgd Global best finite element model at parameter d.  wk The k-th dimension inertia weight.  Mmax, Mmin Maximum and minimum model position respectively.  Vmax, Vmin Maximum and minimum model velocity respectively.  Ei  Young's Modulus.  AIC Akaike Information Criterion.  SSE Sum of Squared Errors.  µ Mean  msrddata Measured structural results.  femresults Finite element model results.   |
|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
