
## 3.2 The Mathematical Models Of The Beam

All models in this example assume the only uncertain beam property is its Young's Modulus (E) value. To design different models of the beam, beam elements are grouped differently. The beam is modelled by eight competing models, mi, i = 1...8. Model m1 assumes the whole beam's Young's modulus is the updating parameter to be updated from the average given material value. Model m2 has two parameter, E1 and E2; the elements numbered 1,4, 6,7,8,9 (all forming parameter E1) are to be varied equally while elements 2, 3, 5, 10, 11, 12 (all E2) are to be varied equally (see figure 1 for the element numberings). 

Model m2 models the elements connected near the structural joints as one parameter and those away from the joints as another. Model m8 assumes the left edge together with the first horizontal element, the horizontal section and right edge together with the last horizontal element are best updated differently, thus the three parameter arrangement. Table 3 lists the rest of the models and their parameterizations. 

| Model    | Number of model   | Parameter      | Element grouping                    |
|----------|-------------------|----------------|-------------------------------------|
| Identity | parameters        | Labels         |                                     |
| m1       | 1                 | E1             | {1-12}                              |
| m2       | 2                 | E1 & E2        | {1,4,6-9} & { 2,3,5,10-12}          |
| m3       | 3                 | E1 E2 E3       | {1,4,6-9}, {2,3,11,12} & {5,10}     |
| m4       | 4                 | E1 E2 E3 E4    | {1,4,6-9}, {2,3} {11,12} & {5,10}   |
| m5       | 5                 | E1 E2 E3 E4 E5 | {1,4,6-9}, {2,3} {11,12},{5} & {10} |
| m6       | 2                 | E1 E2          | {1,2,3,4} & {5-12}                  |
| m7       | 2                 | E1 E2          | {1- 6} & { 7-12}                    |
| m8       | 3                 | E1 E2 E3       | {1-5}, {6-9} & (10,11,12}           |

Perhaps the most important step in the implementation of the PSO algorithm is the choice of particle representation. This fundamentally dictates the problem search space and the ease of algorithm implementation. The next section presents the model representation adopted in the current finite element model updating procedure. 

4. PSO Algorithm 4.1 Particle Representation Each particle or finite element model (mi...m) is described by the following Ei vector arrangement: 

$\left(\mathfrak{g}\right)$. 
m1 = [E1,0,0,0,0]; m2 = [E1,E2,0,0,0]; m3 = [ E1,E2,E3,0,0]; m4 = [E1,E2,E3,E4,0]; 
m5 = [E1,E2,E3,E4,E5]; m6 = [E1,E2,0,0,0]; m7 = [E1,E2,0,0,0]; m8 = [ E1,E2,E3,0,0]; 

where in each case 
 2
$$\begin{array}{c}{{E_{i\ldots5}=\mu+q\sqrt{0.5e20}\mathrm{N.m}^{-2}\,.}}\\ {{\mu=7.2e10\mathrm{N.m}^{-2}\,.}}\end{array}$$
= + . (8)
and the mean 2 µ 7.2 10N.m e
$${\mathrm{and~the~mean}}$$
The q variable samples random numbers from a normal distribution between [-∞, ∞].The parameter location of the models as described in Table 1 nullifies the concern that models m2, m6 and m7 seem to be described by the same parameter vector. This choice of model representation sets the problem search space to five dimensions. Even though all the models search the five dimensional space, each is actually constrained to only searching a particular manifold of the space. This contextually means each subspace is assumed to have an optimum somewhere which the particle is suppose to find guided by individualistic and social performance. This means if model m5 finds the best solution within the group (thus it is pg) at some coordinate/parameter values, all the other particles will adapt towards model m5's parameter values. In this particle representation, all the particle parameters will incrementally change towards model m5's values, even the zeros in the particle vector description. But since, for example, 