
## 4.4 Objective Functions

 
A number of fitness or objective functions are available in the scientific literature. In the FEMU problem Occam's razor is very much applicable. This means one seeks a model with the fewest updating parameters that will produce FE model results closest to measured lab results. In this paper we compare two objective/fitness functions; the Akaike Information Criterion (AIC) [25] and the Squared Sum of Errors (SSE). The AIC function is given by the following equation: 

 
2 *AIC n d* = + log( ) 2 σ (9) 
where, 
 
$$A I C=n\log(\sigma^{2})+2d$$
$$\sigma^{2}=\frac{\sum_{i=1}^{n}\left(m s r d_{d a t a}-f e m_{r e s u l t s}\right)^{2}}{\sigma^{2}=\frac{i=1}{2}},$$
n
, (10) 

 
and d is the number of model parameters, n is the number of measured modes, msrddata is the measured data and femresults are the finite element model results. The squared sum of errors is given by 

$$S S E={\frac{\sum_{i=1}^{n}(m s r d_{d a t a}-f e m_{r e n a t s})^{2}}{2}}$$
 (11) 
$$(10)$$
$$(111)$$

As it can be seen from equations 9 to 11, the first term of equation 9 is effectively the SSE and is commonly referred to as the data-fit term [3, 20, 21, 23] and the second term is known as the model complexity penalty term. 

This assumes a models' complexity is determined by the number of free variables. This is not always the correct way to define model complexity as argued in [22, 23]. The minimization/maximization of the squared sum of error objective function does not account for model complexity but only measures how well a given model fits the data. We would expect the implementation of the AIC function as the objective function in the PSO algorithm to be biased to models with fewer parameters. 

## 5. Simulation Results

The simulations presented in this section are all modelled using Version 6.0 of the Structural Dynamics Toolbox 
(SDT®) for Matlab. A number of simulations were run using different setting of the PSO algorithm parameters. 

Initially the number of iterations in all settings was set to N=1000 but it was found that the algorithm consistently converged before N= 500 iterations. In each of the experiments the convergence figures will only focus on the main convergence part of the graph, where necessary the figure will be expanded to show 500 iterations. 

5.1 Simulation settings 

| PSO Parameter                              | Simulation   | Simulation   | Simulation   | Simulation   |
|--------------------------------------------|--------------|--------------|--------------|--------------|
| No.1                                       | No. 2        | No. 3        | No. 4        |              |
| C1 Local influence                         | 2            | 2            | 2            | 2            |
| C2 Global Influence                        | 2            | 2            | 2            | 2            |
| w                                          | 0            | 0            | Adaptive     | Adaptive     |
| Objective function                         | AIC          | SSE          | AIC          | SSE          |
| Table 3. PSO Simulation parameter settings |              |              |              |              |

5.1.1 Simulation number 1 In this simulation the original PSO algorithm is implemented on the FEMU problem, this means there is no inertia variable as shown in table 3. Figure 2 shows the convergence plot of the AIC objective function over the 200 iterations of the algorithm. Figure 3 shows the variation of the best particle (pg) in the swarm over 10 iterations. 