
## 5.5 A Second Example: Cooking A Chinese Soup

A second example is presented in which the AK discovery process is triggered in response to the user feedback in order to repair the adaptation presented in Sect. 3. In this example, the user is encouraged to formulate the cause of the adaptation failure. A repair strategy is chosen that is used to parametrize the AK discovery process.

1. *Representing the Target Problem.* In this example, the target problem tgt is:
tgt = chinese ∧ soup ∧ leek ∧ ¬ peanut oil In the Taaable interface, the field "Ingredients I Want" is filled in with the token leek, the field "Ingredients I Don't Want" is filled in with the token peanut oil and the field "Types I Want" is filled in with the tokens chinese and soup.

2. *Retrieval.* As in Sect. 3, two substitutions σ1 = ¬ peanut oil ∅ and σ2 =
leek onions are generated automatically from the ontology O. The similarity path SP = σ2 ◦ σ1 is applied to tgt in order to produce the modified query srce = chinese ∧ soup ∧ onions. The system retrieves the recipe *Wonton Soup*, whose representation Sol(srce) solves the query srce:
Sol(srce) is such that Sol(srce) O srce.

3. *Adaptation.* Initially, AKB = ∅, so to construct the adaptation path AP, two substitutions Σ1 = ∅ ¬ peanut oil and Σ2 = green onion leek are automatically generated from σ1 and σ2.

4. *Solution Test and Validation.* The solution Sol g(tgt) is presented to the user for validation, together with the adaptation path AP = Σ1 ◦ Σ2 that was used to generate it.

5. *The User is Unsatisfied!* The user complains that the adapted recipe is practically unfeasible because the proposed solution Sol g(tgt) does not contain oil anymore, and oil is needed to saute the bok choy.

6. *What has Caused the Adaptation Failure?* The cause of the adaptation failure is identified through interactions with the user. The user validates the intermediate solution Sol g(pb) that results from the application of the substitution Σ2 = green onion leek to Sol(srce). But the user invalidates the solution Sol g(tgt) that results from the application of Σ1 = ∅ ¬ peanut oil to Sol g(pb). The substitution Σ1 is identified as responsible for the adaptation failure since its application results in the removal of oil in the recipe.

7. *Choosing a Repair Strategy.* A repair strategy is chosen according to the user's feedback. The user expresses the need for oil in the adapted recipe, so the repair strategy consists in replacing peanut oil by another oil. An AK discovery process is triggered to decide which oil to replace peanut oil with.

8. *Choosing the Training Set.* A set of recipes that contain peanut oil is compared with a set of recipes containing other types of oil. The training set TS is composed of the set of variations ∆kℓ ∈ L∆ between pairs of recipes (Rk, Rℓ) ∈
CB × CB such that {oil=, peanut oil-} ⊆ ∆kℓ.