
## 2 Basic Notions About Cbr

In the following, problems are assumed to be represented in a language Lpb and solutions in a language Lsol. A *source case* represents a problem-solving episode by a pair (srce, Sol(srce)), in which srce ∈ Lpb is the representation of a problem statement and Sol(srce) ∈ Lsol is the representation of its associated solution. CBR aims at solving a *target problem* tgt using a set of source cases CB called the *case base*. The CBR process is usually decomposed in two main steps: retrieval and adaptation. *Retrieval* selects a source case (srce, Sol(srce))
from the case base such that srce is judged to be similar to tgt according to a given similarity criterion. *Adaptation* consists in modifying Sol(srce) in order to propose a candidate solution Sol g(tgt) for tgt to the user. If the user validates the candidate solution Sol g(tgt), then Sol g(tgt) is considered to be a solution Sol(tgt) for tgt.

## 3 Application Context: The Taaable **System**

The Taaable system [3] is a cooking CBR system. In the cooking domain, CBR
aims at answering a query using a set of recipes. In order to answer a query, the system retrieves a recipe in the recipe set and adapts it to produce a recipe satisfying the query. The Taaable system was proposed to participate to the Computer Cooking Contest (CCC) challenge in 2008 [4]. In the CCC challenge, queries are given in natural language and express a set of constraints that the desired recipe should satisfy. These constraints concern the ingredients to be included or avoided, the type of ingredients (e.g., meat or fruit), the dietary practice (e.g., nut-free diet), the type of meal (e.g., soup) or the type of cuisine (e.g.,
chinese cuisine). An example of query is: "Cook a chinese soup with leek but no peanut oil." Recipes are given in textual form, with a shallow XML structure, and include a set of ingredients together with a textual part describing the recipe preparation. The Taaable system is accessible online (http://taaable.fr).

## 3.1 Representation Issues

A Cooking Ontology. The system makes use of a cooking ontology O represented in propositional logic. Each concept of O corresponds to a propositional variable taken from a finite setV of propositional variables. O is mainly composed of a set of concepts organized in a hierarchy, which corresponds, in propositional logic, to a set of logical implications a ⇒ b. For example, the axiom leek ⇒ onions of O states that leeks are onions.

Problem and Solution Representation. In Taaable, a problem pb ∈ Lpb represents a query and a solution Sol(pb) of pb represents a recipe that matches this query.

Lpb and Lsol are chosen fragments of propositional logic defined using the vocabulary V introduced in the cooking ontology O. One propositional variable is