The Training Set. The training set TS is formed by selecting from the case base a set of pairs of recipes (Rk, Rℓ) ∈ CB×CB and by representing for each selected pair of recipes (Rk, Rℓ) the variation ∆kℓ from Rk to Rℓ. The choice of the training set TS results from a set of interactions with the user during which he/she is asked to formulate the cause of the adaptation failure and to pick up a repair strategy.

Representing Variations. The variation ∆kℓ from a recipe Rk to a recipe Rℓ is represented in a language L∆ by a set of properties. Three properties a
-, a
+
and a
= are defined in L∆ for each propositional variable a of V, and ∆kℓ ∈ L∆
contains:
- the property a
-if Rk O a and Rℓ 2O a,
- the property a
+if Rk 2O a and Rℓ O a,
- the property a
=if Rk O a and Rℓ O a.

For example, if:
Rk = chinese ∧ soup ∧ . . . ∧ peanut oil ∧ *Nothing else* Rℓ = chinese ∧ soup ∧ . . . ∧ olive oil ∧ *Nothing else* then ∆kℓ = {chinese=, soup=, oil=, peanut oil-, olive oil+, . . .}, provided that peanut oil O oil, olive oil O oil, Rℓ 2O peanut oil and Rk 2O olive oil.

The inclusion relation ⊆ constitutes a partial order on L∆ that can be used to organize variations by generality: a variation ∆ is more general than a variation ∆
′if ∆ ⊆ ∆
′.

Mining. The learning process consists in highlighting some variations ∆ ∈ L∆
that are more general than a "large" number of elements ∆kℓ of TS. More formally, let support(∆) =
card {∆kℓ ∈ TS | ∆ ⊆ ∆kℓ}
card TS
Learning adaptation rules aims at finding the ∆ ∈ L∆ such that support(∆) ≥
σs, where σs ∈ [0; 1] is a learning parameter called the support threshold. It can be noticed that if ∆1 ⊆ ∆2 then support(∆1) ≥ support(∆2). The support threshold also has an influence on the number of generated variations. The number of generated variations increases when σs decreases. Thus, specifying a high threshold restricts the generation of variations to the most general ones, which can limit the number of generated variations and save computation time but has the effect to discard the most specific ones from the result set.

Each learned variation ∆ = {p1, p2, . . . , pn
} ∈ L∆ is interpreted as a substitution of the form A B such that:
- A O a and B 2O a if a
- ∈ ∆,
- A 2O a and B O a if a
+ ∈ ∆,
- A O a and B O a if a
= ∈ ∆.

For example, the variation ∆ = {oil=, peanut oil-, olive oil+} is interpreted as the substitution Σ = peanut oil olive oil. The conjunct oil is not present neither in A nor in B since it is useless: peanut oil O oil and olive oil O oil.