# On Backtracking In Real-Time Heuristic Search

Valeriy K. Bulitko Centre for Science, Athabasca University, 1 University Drive Athabasca, Alberta, T9S 3A3, CANADA
valeriyb@athabascau.ca Vadim Bulitko Department of Computing Science, University of Alberta Edmonton, Alberta, T6G 2E8, CANADA
bulitko@ualberta.ca September 13, 2021

## Abstract

Real-time heuristic search algorithms are suitable for situated agents that need to make their decisions in constant time. Since the original work by Korf nearly two decades ago, numerous extensions have been suggested. One of the most intriguing extensions is the idea of backtracking wherein the agent decides to return to a previously visited state as opposed to moving forward greedily. This idea has been empirically shown to have a significant impact on various performance measures. The studies have been carried out in particular empirical testbeds with specific real-time search algorithms that use backtracking. Consequently, the extent to which the trends observed are characteristic of backtracking in general is unclear. In this paper, we present the first entirely theoretical study of backtracking in real-time heuristic search. In particular, we present upper bounds on the solution cost exponential and linear in a parameter regulating the amount of backtracking. The results hold for a wide class of real-time heuristic search algorithms that includes many existing algorithms as a small subclass.

Keywords: real-time heuristic search, agent-centered search.

## 1 Introduction

In this paper we study the problem of *agent-centered real-time heuristic search* (Koenig, 2001). The distinctive property of such search is that an agent must repeatedly plan and execute actions within a constant time interval that is independent of the size of the problem being solved. This restriction severely limits the range of applicable algorithms. For instance, static search algorithms (e.g., A* of Hart, Nilsson, & Raphael, 1968), re-planning algorithms (e.g., D* of Stenz, 1995), anytime algorithms (e.g., ARA* of Likhachev, Gordon, & Thrun, 2004) and anytime re-planning algorithms (e.g., AD* of Likhachev, Ferguson, Gordon, Stentz, & Thrun, 2005) cannot guarantee a constant bound on planning time per action. LRTA* provides such guarantees by planning only a few actions at a time and updating its heuristic function, but the solution quality can be poor (Korf, 1990; Ishida, 1992).

As a motivating application, consider navigation in gridworld maps in commercial computer games. In such games, an agent can be tasked to go to any location on the map from its current location. The agent must react quickly to the user's command regardless of the map's size and complexity. Consequently, game