Example 2 (Beyond LRTS). Consider the 4-state search space and the initial heuristic from Example 1.

The start state C is called 1-trap (Bulitko, 2004) with respect to the immediate neighbors since the fvalue of the left neighbor is f(B) = dist(*C, B*) + hinit(B) = 2, the f-value of the right neighbor is f(D) = dist(*C, D*)+hinit(D) = 1.7 and they both exceed the heuristic value of the start state: hinit(C) = 1.

In such cases, the agent may want to expand the search space until the current state is no longer a trap or an upper-bound dmax is reached. This can be implemented in the framework:

$$\Gamma(\sigma_{t})=S(s_{c},d)$$ $$s_{c}=\mathrm{top}(\sigma_{t})$$ $$S(s_{c},k)=\{s\in S\mid\|s_{c},s\|=k\}$$ $$d=\min\left\{d_{\max},\|s_{c},S_{g}\|,\min\left\{k\left|\ h_{t}(s_{c})\geq\min_{s\in S(s_{c},k)}f(s)\right.\right\}\right\}$$ $$f(s)=\gamma(\sigma_{t})\,\mathrm{dist}(s_{c},s)+h_{t}(s).$$
 $\text{(4.10)}$  $\text{(4.11)}$  $\text{(4.12)}$  $\text{(4.13)}$  $\text{(4.14)}$  . 
$$(4.15)$$
 (4.13)
Intuitively, S(sc, d) defines a depth d full-width neighborhood which is guaranteed to be a separating set unless sc ∈ Sg. Additionally, we update the heuristic over the entire lookahead space:

$$\forall s\in\Gamma(\sigma_{t})\left[h_{t+1}(s)=\operatorname*{max}\left\{h_{t}(s),\operatorname*{max}_{S^{\prime}\in\mathfrak{D}(s,\Gamma(\sigma_{t}))}\operatorname*{min}_{s^{\prime}\in S^{\prime}}f(s^{\prime})\right\}\right],$$
 , (4.15)
where f(·) is defined in Equation 4.14. Note that all updates from htto ht+1 are done in parallel (called synchronous backups by Barto, Bradtke, & Singh, 1995). The fact that the new value of each s ∈ Γ(σt) is a minimum f-value over a separating set S
0 ∈ D(s, ·) maintains γ-admissibility of the heuristic. The distance weight γ(σt) is set to 1 for all t. We finalize the algorithm by setting T to ∞ thereby disabling backtracking.

The resulting algorithm is 1-admissible search in the sense of Axiom 2. On the other hand, the algorithm goes beyond the LRTS framework due to dynamic search space growth (line 4.13) and multiple heuristic updates (line 4.15).

In Example 2 above, we used the γ-Trap 's and LRTS' "max of mins" update rule (Equation 4.15) which maintains γ-admissibility of the heuristic. The intuition lies with the fact that the minima are sought over separating sets. This means that each minimum is computed over a set of states that an optimal path to every goal state through. Clearly, it is safe to increase the heuristic value of the current node to the f-value of any state on an optimal path as it will not violate (weighted) admissibility. Thus, it is safe to increase h of the current state to the minimum f value of any separating set. As the initial heuristic is θ-admissible, it makes sense to increase it as aggressively as possible (hence the max in the update rule). Note that the classic LRTA* seeks the minimum of f-values over depth d frontier which is a separating set. LRTS and γ-Trap are more aggressive and look at a series of frontiers for the depth values of 1*, . . . , d*. They then select the highest minimum as the new value of the heuristic value of the current state.

Interestingly, the "max of mins" update rule is a sufficient but not necessary to preserve θ-admissibility of heuristic function. In Appendix A we show that even more aggressive θ-admissible rules are possible.

More importantly, we derive a criterion for θ-admissibility and construct an non-trivial upper-bound on the magnitude of the updates for any θ-admissible learning rule.

## 5 Theoretical Analysis

We start by proving that any θ-admissible search (Definition 13) is complete.