Definition 14 (Linear subclass). A search π belongs to the linear class if its solution cost has an upper bound linear in T. Specifically, a θ-admissible search π belongs to the linear subclass if there exist nonnegative numbers *a, b, c* (that possibly depend on θ, γ¯) such that the solution cost is upper-bounded by a dist(s0, Sg) + bT + c.

While traversing the state space, a θ-admissible search can visit a single state more than once. Such revisits happen either through backtracking moves (the stack shrinks) or forward moves (the stack grows). In the latter case, several copies of the revisited state will be present on the search's path stack at once thereby forming a cycle in the solution.

Definition 15 A θ-admissible search is called *acyclic* when its stack never contains multiple occurrences of a state.

The LRTS algorithm of Bulitko and Lee (2006) is an example of acyclic search because it explicitly removes any cycles in its solution.

Theorem 5.4 Any acyclic θ-admissible search belongs to the linear class.

Another example of search with linear solution bound is achieved through limited backtracking as follows.

Definition 16 A θ-admissible search π is called *piecewise backtracking* if for a positive integer k the following conditions hold:

1. the path stack is divided into a finite number of segments. Each segment except possibly the last (i.e.,
top-most) segment are exactly k-states each. We will denote stack segment i by σ| ei bi where sbi is the first state and sei is the last state of the stack segment. For all, except possibly the last segment, ei − bi = k − 1. The first segment begins with the start state: b1 = 0; 2. within each segment, every increase in the heuristic function (i.e., when ht(s) < ht+1(s)) results in a backtracking move as long as it does not bring the agent into the previous segment. In other words, if the current state s = top(σt) is the first state of a segment than no move is taken at all when ht(s) is increased (i.e., the agent stays put);
3. every time the current stack segment (i.e., the segment containing the top of the stack) grows beyond k states, a new segment is started. Suppose its first state is top(σ) = sbM . Then the following quantity is computed:
$$\sum_{i=1}^{M-1}h{\big(}s_{b_{i+1}}{\big)}-h{\big(}s_{e_{i}}{\big)}+\operatorname{dist}(s_{e_{i}},s_{b_{i+1}}{\big)}.$$
, sbi+1 ). (5.1)
Once this quantity exceeds T, the segment that was just started is declared final. This means that it can grow beyond k states. As with other segments, each increase in a heuristic value forces the agent to take backtracking move *within* the segment. Backtracking is not allowed into the previous segments
(i.e., past sbM ).

$$(5.1)$$
