edge/transition originating in the state s corresponds to an action the search agent can take in s. The function w : E → {εn | n ∈ N*, n >* 0} specifies the edge weights (i.e., action costs). Here ε ∈ R
+ is a positive constant. Henceforth, R
+ is a set of positive real numbers and R
⊕ = R
+ ∪ {0}.

Note that unlike the standard definition (e.g., Bulitko & Lee, 2006), in this paper we consider a more general case of a possibly infinite search space and multiple goal states.

Definition 2 *Distance* dist(s1, s2), s1, s2 ∈ S is defined as the minimum cumulative weight of a path originating in s1 and ending in s2. Such a path is called the *shortest path*. We generalize this definition for arbitrary sets of states S
0, S00 ⊂ S as follows: dist(S
0, S00) = min s 0∈S0,s00∈S00 dist(s 0, s00). Thus, ∀s1, s2 ∈
S, dist(s1, s2) = dist({s1}, {s2}). *Distance to goal* of the state s is defined as h
∗(s) = dist(*s, S*g) =
min sg∈Sg dist(*s, s*g).

Definition 3 Edge-distance k*s, s*0k is the minimum number of edges among all shortest paths between the states s and s 0. For any S
0, S00 ⊂ S, we define kS
0, S00k = min s 0∈S0,s00∈S00 ks 0, s00k.

Definition 4 A *heuristic search problem* is defined by the search space G(*S, E, w*), the goal subset Sg, an initial heuristic hinit, and an initial state s0. The initial heuristic function hinit (e.g., Manhattan distance) is a mapping from S to {εn | n ∈ N, n ≥ 0}. The heuristic hinit(s) is an estimate of h
∗(s) and is available to the agent. A heuristic is called θ*-admissible* if ∀s ∈ S [h(s) ≤ θh∗(s)]; θ is a positive constant. A heuristic is called *consistent* if for any two states a and b, |h(a) − h(b)| does not exceed dist(*a, b*).

Definition 5 A heuristic search agent operates as follows. It starts in the initial state s0 and traverses the graph by taking the actions (i.e., directed edges of the graph) until it enters a goal state.

In this paper we do not consider resetting the agent back to its start state upon reaching a goal state and having it solve the problem again. In other words, we are concerned with the first solution only and do not consider the learning process over multiple trials (known as convergence).

Axiom 1 The search problem satisfies the following conditions for some θ ∈ R*, θ >* 0:

$$\begin{array}{l}{{\forall s\in S\,\exists s^{\prime}\in S_{g}\left[\operatorname{dist}(s,s^{\prime})<\infty\right];}}\\ {{\forall s\in S\left[|\{s^{\prime}|(s,s^{\prime})\in E\}|<\infty\right];}}\\ {{\forall s\in S\left[h_{\operatorname*{init}}(s)\leq\theta\operatorname{dist}(s,S_{g})\right].}}\end{array}$$
$\eqref{eq:walpha}$
 $\left(3.2\right)$  $\left(3.3\right)$
Condition 3.1 postulates that a goal state is reachable from every state. Next, condition 3.2 states that the number of actions available in any state is finite (i.e., each vertex of the search graph has a finite degree).

Finally, condition 3.3 stipulates that the initial heuristic hinit is θ-admissible. These conditions are needed to ensure completeness (defined below) of the algorithms covered by our framework in the next section.

Definition 6 (Completeness). A search algorithm is *complete* for a search problem if and only if it necessarily reaches a goal state after a finite number of edge traversals.

## 4 A Framework Of Learning Real-Time Heuristic Search

This section presents a framework of real-time heuristic search which we subsequently use in our analysis. We introduce the framework axiomatically and then illustrate it with examples.