Z as follows: For each partial morphism φ ∈ M, we construct a complete subgraph Zφ of ZXY with vertex set V (Zφ) = Cφ = {iiφ: i ∈ D(φ)}. The vertex set Cφ is a clique in ZXY such that f(*φ, X, Y* ) = ω(Vφ). We obtain an association graph Z ⊆ ZXY by taking the union of all subgraphs Zφ with φ ∈ M. Then be construction Z satisfies property P1. Note that construction of Z in the above way is impractical, because it requires enumeration of all members of M. But it provides a simple way to show that there is always an association graph satisfying property P1. Ad P2: Now let us turn to the second property P2. We first provide a fictitious example to show that P2 does generally not hold.

Example 1. Consider the set M2 of partial morphisms φ : V (X) → V (Y ) **that are**
defined on subsets of exactly two vertices from X*, i.e.*D(φ) = 2 < |X|*. Suppose that* we construct Z as described in the previous paragraph. Then the set CZ(M2) **of all**
cliques encoding morphisms from M2 are cliques in Z **with exactly two vertices. We may**
encounter the following pitfalls:
PF1. Let C = {i, j} be a clique in Z **encoding** φ ∈ M2. Then {i} and {j} **are both**
cliques in Z *not contained in* CZ(M2).

PF2. Let C, C0, C00 be cliques from CZ(M2) **with** C = {*i, j*}, C
0 = {j, k}*, and* C
00 =
{i, k}**. Then** C = {i, j, k} is a clique in Z **with three vertices and therefore not**
contained in CZ(M2).
Hence, we have CZ(M2) 6= CZ *and therefore a graph matching problem (5) defined on* M2 *is not equivalent to clique search in an association graph.*
Example 1 indicates that equivalence between graph matching and clique search depends on the structure of the search space M. So our central question of issue reduces to a necessary and sufficient condition on M such that CZ(M) = CZ.

## A Necessary And Sufficient Condition

The goal is to present an intuitive idea of a necessary and sufficient condition for CZ(M) = CZ. Our claim is that CZ(M) = CZ holds whenever there is a *property* that completely describes the set M.

First, we specify the notion of property. Given a graph matching problem, the purpose of a property is to describe the characteristics of the search space M in such a way that we can derive the desired equivalence relationship. For example, let M be the set of all partial morphisms φ from MXY that satisfy the property p to be injective.

Although property p completely describes the characteristics of M, it is not suitable to deal with it conveniently. The reason is as follows: According to the pitfalls PF1 and PF2 of Example 1, we have to show that restrictions and feasible unions of morphisms that satisfy property p also satisfy p. This task is unnecessarily complex and can be simplified by imposing a locality restriction on the notion of property.

A *property* p on a set S is a binary function p : *S → {*0, 1}. We say an element x ∈ S
satisfies property p if p(x) = 1 for each x ∈ S0. We can extend the notion of a property