set uniformly distributed over both classes. We describe molecules by graphs in the usual way: atoms are represented by vertices labeled with the atom type of the corresponding atom and bonds between atoms are represented by edges labeled with the valence of the corresponding bonds. We used a 1-to-k binary encoding for representing atom types and valence of bonds, respectively.

## 5.2 General Experimental Setup

In all experiments, we applied standard k-means for graphs (std) and Elkan's k-means for graphs (elk) to the aforementioned data sets using the following experimental setup:
Setting of k-means algorithms. To initialize the k-means algorithms, we used a modied version of the "furthest rst" heuristic [9]. For each data set S, the rst centroid Y1 is initialized to be a graph closest to the sample mean of S.

Subsequent centroids are initialized according to

## Yi+1 = Arg Max X∈S Min Y ∈Yi D(X, Y ),

where Yiis the set of the rst i centroids chosen so far. We terminated each kmeans algorithm after 3 iterations without improvement of the cluster objective JT .

Graph distance calculations and optimal alignment. For graph distance calculations and nding optimal alignments, we applied a depth rst search algorithm on the letter data set and the graduated assignment [8] on the grec, ngerprint, and molecule data set. The depth rst search method guarantees to return optimal solutions and therefore can be applied to small graphs only. Graduated assignment returns approximate solutions.

Performance measures. We used the following measures to assess the performance of an algorithm on a dataset: (1) error (value of the cluster objective JT ), (2) classication accuracy, (3) silhouette index, and (4) number of graph distance calculations.

The silhouette index is a cluster validation index taking values from [−1, 1].

Higher values indicate a more compact and well separated cluster structure. For more details we refer to Appendix A and [24]. Elkan's k-means and graph-vector reduction k-means incur computational overhead to create and update auxiliary data structures and to compute Euclidean distances. This overhead is negligible compared to the time spent on graph distance calculations. Therefore, we report number of graph distance calculations rather than clock times as a performance measure for speed.

## 5.3 Performance Comparison

We applied standard k-means (std) and Elkan's k-means (elk) to all four data sets in order to assess and compare their performance. The number k of centroids