For pairwise clustering, the number of NP-hard graph distance calculations depends quadratically on the number of the input patterns. In the worst-case, when almost all patterns are in one cluster, k-medoids also has quadratic complexity in the number of distance calculations. If the N graph patterns are uniformly distributed in k clusters, k-medoids requires O(tN2/k) graph distance calculations, where t is the number of iterations required. For k-means, we require kN graph distance calculations at each iteration in order to assign N pattern graphs to their closest centroids. Recomputing the centroids requires additional graph distance calculations. In the best case, when using the incremental arithmetic mean method [15] for approximating a sample mean, N graph distance calculations at each iteration are necessary to recompute the centroids. This gives a total of t(k + 1)N graph distance calculations, where t is the number of iterations required. In view of the exponential complexity of the graph matching problem, reducing the number of distance calculations in order to make k-means for graphs applicable is imperative.

In this contribution, we propose an accelerated version of k-means for graphs by extending Elkan's method [5] from vector to graphs. For this we assume that the underlying graph distance is a metric. To avoid computationally expensive graph distance calculations, we exploit the triangle inequality by keeping track of upper and lower bounds between input graphs and centroids.

The k-means algorithm for graphs generalizes the standard k-means algorithm for vectors. Regarding feature vectors as graphs consisting of a single attributed node, k-means for graphs coincides with k-means for vectors. The proposed accelerated version of k-means for graphs has the following properties:
First, based on the T -space framework, accelerated k-means can be applied to nite combinatorial structures other than graphs like, for example, point patterns, sequences, trees, and hypergraphs. For sake of concreteness, we restrict our attention exclusively to the domain of graphs. Second, any initialization method that can be used for k-means for graphs can also be used for the Elkan's kmeans for graphs. Third, k-means for graphs and its accelerated version perform comparable with respect to solution quality. Dierent solutions are due to the approximation errors of the graph matching algorithm and the non-uniqueness of the sample mean of graphs but are not caused by the mechanisms to accelerate the clustering algorithm.

The paper is organizes as follows. Section 2 briey describes the standard k-Means algorithm for vectors. Section 3 extends the standard k-means from vectors to graphs. Section 4 introduces Elkan's k-means algorithm for graphs.

Experimental results are presented and discussed in Section 5. Finally, Section 6 concludes with a summary of the main results and future work.

## 2 The K-Means Algorithm For Euclidean Spaces

This section describes k-means for vectors [24] in order to point out commonalities and dierences with k-means for graphs.