by a graph metric. Second, we replace the sample mean of vectors by a related concept for graphs.

## 3.1 Metric Graph Spaces

In principle, we can substitute any graph metric into the standard k-means algorithm in order to obtain its structural counterpart. Here, we focus on geometric graph distances that are related to the Euclidean metric, because the Euclidean metric is the underlying metric of the vectorial mean. The vectorial mean in turn provides a link to deep results in probability theory and is the foundation for a rich repository of analytical tools in pattern recognition. To access at least parts of these results, it seems to be reasonable to relate graph metrics to the Euclidean metric. This restriction is acceptable from an application point of view, because geometric distance functions on graphs and their related similarity functions are a common choice of proximity measure [1, 3, 8, 10, 25, 27].

Though it is straightforward to dene a graph metric, which is related to the Euclidean metric of vectors, we rst make a detour via the concept of T -space in order to approach the sample mean of graphs in a principled way.

Let E be a d-dimensional Euclidean vector space. An (attributed) graph is a triple X = (*V, E, α*) consisting of a nite nonempty set V of vertices, a set E ⊆ V × V of edges, and an attribute function α : V × V → E, such that α(*i, j*) 6= 0 for each edge and α(*i, j*) = 0 for each non-edge. Attributes α(*i, i*) of vertices i may take any value from E.

For simplifying the mathematical treatment, we assume that all graphs are of order n, where n is chosen to be suciently large. Graphs of order less than n, say m < n, can be extended to order n by including isolated vertices with attribute zero. For practical issues, it is important to note that limiting the maximum order to some arbitrarily large number n and extending smaller graphs to graphs of order n are purely technical assumptions to simplify mathematics. For machine learning problems, these limitations should have no practical impact, because neither the bound n needs to be specied explicitly nor an extension of all graphs to an identical order needs to be performed. When applying the theory, all we actually require is that the graphs are nite.

A graph X is completely specied by its matrix representation X = (xij )
with elements xij = α(*i, j*) for all 1 ≤ *i, j* ≤ n. By concatenating the columns of X, we obtain a vector representation x of X.

Let X = E
n×n be the Euclidean space of all (n×n)-matrices and let T denote a subset of the set P
n of all (n×n)-permutation matrices. Two matrices X ∈ X
and X0 ∈ X are said to be equivalent, if there is a permutation matrix P ∈ T
such that P TXP = X0. The quotient set

## Xt = X /T = {[X] : X ∈ X }

is the T -space over the representation space X . A T -space is a relaxation of the set GT = G/T of all abstract graphs [X], where X is a matrix representation of graph X.