
## 1 Introduction

Qualitative Reasoning about space abstracts from the physical world and enables computers to make predictions about spatial relations, even when precise quantitative information is not available [1]. A *qualitative* representation provides mechanisms which characterize the essential properties of objects or configurations. In contrast, a *quantitative* representation establishes a measure in relation to a unit of measurement which must be generally available [2]. The constant and general availability of common measures is now self-evident. However, one needs only recall the history of length measurement technologies to see that the more local relative measures, which are represented qualitatively1, can be managed by biological/epigenetic cognitive systems much more easily than absolute quantitative representations.

Qualitative spatial calculi usually deal with elementary objects (e.g. positions, directions, regions) and qualitative relations between them (e.g. "adjacent", "to the left of", "included in"). This is the reason why qualitative descriptions are quite natural for people. The two main trends in Qualitative Spatial Reasoning (QSR) are topological reasoning about regions [3, 4, 5, 6, 7]
and positional (e.g. direction and distance) reasoning about point configurations [8, 9, 10, 11, 12, 13, 14]. Positions can refer to a global reference system, e.g. cardinal directions, or just to local reference systems, e.g. egocentric views. Positional calculi can be related to the results of Psycholinguistic research [15] in the field of reference systems. In Psycholinguistics, local reference systems are divided into two modalities: intrinsic reference systems and extrinsic reference systems. Then, the three resulting options for giving a linguistic description of the spatial arrangements of objects are: intrinsic, *extrinsic*, and *absolute* (i.e.

global) reference systems [16]2. Corresponding QSR calculi can be found in Psycholinguistics for all three types of reference systems. An intrinsic reference system employs an oriented physical object as the origin of a reference system
(relatum). The orientation of the physical object then serves as a reference direction for the reference system. For instance, an intrinsic reference system is used in the calculus of oriented line segments (see Fig. 1) which is the main topic of this paper. Another calculus corresponding to intrinsic reference systems is the *OPRA* calculus [17]. In the *OPRA* calculus, oriented points are the basic entities (see Fig. 5).

Extrinsic reference systems are closely related to intrinsic reference systems.

Both reference system options share the feature of focusing on the local context.

The difference is that the extrinsic reference system superimposes the view direction from an external observer as reference direction to the relatum of the reference system. A typical example for a QSR calculus corresponding to an extrinsic reference system is Freksa's double cross calculus [18]. In the double cross calculus, two points span a reference system to localize a third point. The first point then projects a view towards the second point which generates the 1Compare for example the qualitative expression "one piece of material is longer than another" with the quantitative expression "this thing is two meters long" 2In [16], extrinsic references are called relative references.