Altogether, we get the following diagram of calculi (weak representations)
and homomorphisms among them:

![0_image_0.png](0_image_0.png)

## 2.4 Constraint Reasoning

Let us now apply the relation-algebraic method to constraint reasoning. Dipole constraints are written as xRy, where *x, y* are variables for the dipoles and R is a DRAf or DRAfp relation. Given a set Θ of dipole constraints, an important reasoning problem is to decide whether Θ is *consistent*, i.e., whether there is an assignment of all variables of Θ with dipoles such that all constraints are satisfied (a *solution*). We call this problem DSAT. DSAT is a Constraint Satisfaction Problem (CSP) [51]. We rely on relation algebraic methods to check consistency, namely the above mentioned path consistency algorithm. For non-associative algebras, the abstract composition of relations need not coincide with the (associative) set-theoretic composition. Hence, in this case, the standard path-consistency algorithm does not necessarily lead to path consistent networks, but only to algebraic closure [26]:
Definition 23 (Algebraic Closure). A CSP over binary relations is called *algebraically closed* if for all variables X1, X2, X3 and all relations R1, R2, R3 the constraint relations

$$R_{2}(X_{2},X_{3}),$$
R1(X1, X2), R2(X2, X3), R3(X1, X3)

## Imply R3 ≤ R1; R2.

In general, algebraic closure is therefore only a one-sided approximation of consistency: if algebraic closure detects an inconsistency, then we are sure that the constraint network is inconsistent; however, algebraic closure may fail to detect some inconsistencies: an algebraically closed network is not necessarily consistent. For some calculi, like Allen's interval algebra, algebraic closure is known to exactly decide consistency, for others it does not, see [26], where it is also shown that this question is completely orthogonal to the question as to whether the composition is strong. We will examine these questions for the dipole calculi in Section 3 below.

Fortunately, it turns out that oplax homomorphisms preserve algebraic closure.