
## 3.6 Implementation Of The Classification Procedure

Qualitative composition configurations can be naturally represented as a finite datatype. The classifiers are implemented as simple programs (mainly case distinctions) that operate on *qccs* in the sense of Def. 29. The classifiers are chosen with respect to the identifier i and the assignment mapping a of the qcc. In our particular implementation, we exploited some symmetries to limit the number of classifiers that we had to implement.

With the condensed semantics, we are able to compute the composition tables of the DRA calculi in an efficient way. In fact we have implemented the computation of composition tables for both DRAf and DRAfp as Haskell programs, making use of Haskell's parallelism extensions. The Haskell implementations of the basic classifiers for DRAf and DRAfp are written in such a way that they share a library of primitive classifiers. In these programs, we further generate all qccs in an optimized way, i.e. we only generate the order
<p if it is needed, and classify them with our basic classifiers. In the end, we compose our results into composition tables. For the case where three lines are collinear, we simply decided to enumerate all possible locations of points in a certain interval for reasons of simplicity and this did not increase the overall runtime too much.

The computation of the composition table for DRAf takes less than one minute on a Notebook with an Intel Core 2 T7200 with 1.5 Gbyte of RAM,
and the computation of the composition table for DRAfp takes less than two minutes on the same computer. This is a great advancement compared to the enumeration of scenarios on a grid, which took several weeks to compute only an approximation to the composition table.

## 3.7 Properties Of The Composition

We have investigated several properties of the composition tables for DRAf and DRAfp. For both tables the properties

id^ = id

| (R ^) ^     | =         | R   |    |
|-------------|-----------|-----|----|
| id ◦ R      | =         | R   |    |
| R ◦ id      | =         | R   |    |
| (R1 ◦ R2) ^ | =         | R   |    |
| 1           | ∈ R2 ◦ R3 | ⇐⇒  | R  |
| ^           |           |     |    |

(R1 ◦ R2)
^ = R
^
2 ◦ R
^
1
$$R_{1}^{-}\in R_{2}\circ R_{3}$$
1 ∈ R2 ◦ R3 ⇐⇒ R
^
3 ∈ R1 ◦ R2 hold with R, R1, R2, R3 being any base-relation and id the identical relation.

These properties can be automatically tested by the GQR and SparQ qualitative reasoners. The other properties for a non-associative algebra follow trivially.

Furthermore, we have tested the associativity of the composition. For DRAf ,
we have 373248 triples of relations to consider of which 71424 are not associative. So the composition of 19.14% of all possible triples of relations is not