with green arrows, the input street observations are marked with red arrows.

The result shows that for all street pairs which could not be observed directly, the algebraic closure algorithm deduces a strong constraint/precise information. Typically, the resulting spatial relation between street pairs comprises just one DRAfp base relation. The exception consists of four relations between streets in which the three models differ (marked with dashed blue arrows in Fig. 31).

For these four relations each model from the solution set agrees on the same DRAf base relation for a given relation, but the three consistent models differ on the finer granularity level of DRAfp base relations. Since the refinement of one of these four underspecified relations on a single interpretation (DRAfp base relation) as a logical consequence also assigns a single base relation to the other three relations, only three interpretations are valid models. The uncertainty/indeterminacy is the result of the specific street configuration in our example. The streets in a North-South direction are parallel, but the streets in an East-West direction are not parallel resulting in fewer constraint composition results. However, the small solution set of consistent models agrees on most of the relative position relations between street pairs and the differences between models are small. In our judgement, this means that the system has generated the relevant survey knowledge about the whole street network from local observations alone.

## 6 Summary And Conclusion

We have presented different variants of qualitative spatial reasoning calculi about oriented straight line segments which we call dipoles. We have derived calculi for oriented points from dipole calculi, which turned out to be isomorphic to some versions of the *OPRA* calculi. These spatial calculi provide a basis for representing and reasoning about qualitative position information in intrinsic reference systems.

We have computed the composition table for dipole calculi by a new method based on the algebraic semantics of the dipole relations. We have used a socalled condensed semantics which uses the orbits of the affine group GA(R
2)
to provide an abstract symbolic notion of qualitative composition configuration. This can be used to compute the composition table in a computer-assisted way. The correctness of this computation is ensured by letting the computer program directly operate with qualitative composition configurations.

This has been the first computation of the composition table for DRAfp. So far, only composition tables for DRAc and DRAf exist, which contain many errors [59]. We have analysed the algebraic features of the various dipole calculi.

We have proved the result that DRAfp has strong composition. This is an interesting result, because in this case an application-motivated calculus extension has been found to also have a certain mathematical elegance. Moreover, the strength of composition carries over to DRAopp, the *OPRA* variant introduced in this paper. This transfer of properties from one calculus to another calculus is an important new general result on quotients of qualitative calculi. To our