Definition 1. The operator % takes the four LR relations between the start and end points of two dipoles and constructs a relation between dipoles. It is defined as the textual concatenation: %(R1, R2, R3, R4) = R1R2R3R4. By τi with 1 ≤
i ≤ 4, we denote the projections to components of the relations between dipoles, where the identities %(τ1R, τ2R, τ3R, τ4R) = R and τi ◦ %(R1, R2, R3, R4) = Ri hold.

The relations that have been introduced above in an informal way can also be defined in an algebraic way. Every dipole D on the plane R
2is an ordered pair of two points sD and eD, each of them being represented by its Cartesian coordinates x and y, with *x, y* ∈ R and sD 6= eD.

## D = (Sd, Ed), Sd = ((Sd)X,(Sd)Y)

The basic relations are then described by equations with the coordinates as variables. The set of solutions for a system of equations describes all the possible coordinates for these points. One first such specification was presented in Moratz et. al. [28].

## 2.2 Several Versions Of Sets Of Dipole Base Relations

It is an unrealistic goal to provide a single set of qualitative base relations which is suitable for all possible contexts. In general, the desired granularity of a representation framework depends on the specific application [35]. A coarse granularity only needs a small set of base relations. Finer granularity can lead to a large number of base relations. If it is desired to apply a spatial calculus to a problem, it is therefore advantageous when a choice can be made between several versions of sets of base relations. Then a calculus may be selected which only has the necessary number of base relations and thus has less representation complexity but is fine-grained enough to solve the particular spatial reasoning problem. Focussing on the smallest number of base relations also fits better with the principle of a vocabulary of concepts which is compatible with linguistic principles [15, 14]. For this purpose, several versions of sets of dipole base relations can be constructed based on the base relation set of DRAf .

In their paper on customizing spatial and temporal calculi, Renz and Schmid
[36] investigated different methods for deriving variants of a given calculus that have better-suited granularity for certain tasks. In the first variant, unions of base relations or so-called macro relations were used as base relations. In the second variant, only a subset of base relations was used as a new set of base relations. In his pioneering work on dipole relations, Schlieder [24] introduced a set of base relations in which no more than two start or end points were on the same straight line. As a result, only a subset of the DRAf base relations is used, which corresponds to Renz' and Schmid's second variant of methods for deriving new base relation sets for qualitative calculi. We refer to a calculus based on these base relations as DRAlr (where lr stands for left/right). The following base relations are part of DRAlr : rrrr, rrll, llrr, llll, rrrl, rrlr, rlrr, rllr, rlll, lrrr, lrrl, lrll, llrl, lllr.