The characterization of integrated information is based on another concept, always defined by Tononi and coauthors, named *effective information* and modeling how much information is gained by an external observer on the previous state of a system from checking which is its current state, with respect to what can "a priori" be deduced on the previous state from the known dynamics of the system itself. Given this emphasis on the experimental side of the knowledge acquisition process, we suggest here to use the terms "experimental information" or "Galileian information" as synonyms for "effective information".

Effective information is zero for static systems or uniformly random systems, which is consistent with everyday scientist's experience. And, similarly, integrated information is also zero for disconnected systems, independently from their kind.

## 2 Probabilistic Boolean Networks

Let X = (**V, E**) be a directed graph with n boolean nodes, i.e. taking values in {0, 1}. The value taken by a node is called also its *state*. Edge (**u, v**) ∈ E models the fact that node v gets in input the state of u. We assume time runs in discrete steps or instants, and nodes may change their value with the flow of time depending on (the value of) the states of their input nodes.

Temporal evolution of state of node i is given by a law fi: {0, 1}
ni → {0, 1} computing state of i at the next time instant as a function only of the current state of its ni ≤ n input nodes. Self loops are admitted. Nodes can all have the same law f or each node can have its specific law. In any case laws are constant with time.

We call X as defined above a *Deterministic Boolean Network*. To put things into context, Random Boolean Networks have been defined in the literature since many years, differing from the deterministic version only in the fact that each fiis randomly chosen when building the network. Random boolean networks have been widely studied as model for gene expression in biological systems.

Various probabilistic versions of Boolean Networks have also been defined, different from ours, for example [4], where each node at each time instant randomly chooses, according to a given probability distribution, the law to be used from a finite domain of admissible laws.

Our version of *Probabilistic Boolean Network* (PBN, for short) assumes the probabilistic law ri:
{0, 1}
ni → [0, 1] associated to node i provides for each configuration of the states of the niinput nodes the probability rithat at the next time instant node i has (equivalently, is in) state 1 (being then 1− rithe probability i is in state 0). It can be shown that this model can describe every network defined according to the model introduced in [4]. In the following we use interchangeably the terms system and network.

At each time instant t a PBN can be in any of its 2 nstates, we assume are provided of some arbitrary enumeration {xi}. State of network X at time t is denoted Xt. A PBN can also be considered as a Markov chain with a finite space state.