
## 3.6 Integration On Orbifolds

Suppose that Q = (X *, Γ, π*) is a Riemannian orbifold with singular set SQ. In order to integrate orbifold functions f : XΓ → R by the Lebesgue integral, we need to construct an appropriate measurable space together with an orbifold measure. The measurable space is defined by the Borel set B(XΓ ) generated by the open sets of XΓ . From the orbifold measure we expect that it is compatible with the local Riemannian measures. In addition, we demand that the singular set SQ has measure 0. This is motivated by the following fact: The singular set is covered locally by the finite union of totally geodesic submanifolds, which has measure 0 relative to the local canonical Riemannian measure. Since the projection to the orbifold is distance decreasing, it is reasonable to ask for an orbifold measure that assigns measure 0 to the singular set SQ.

Let B (XΓ \ SQ) denote the Borel set generated by the open sets of XΓ \
SQ. Then there exists a complete canonical measure µ on the the Borel set B (XΓ \ SQ) given by a unique volume form on XΓ \ SQ. The measure µ can be extended to a complete measure ν on the Borel set B(XΓ ) such that

$$\nu\left({\mathcal{A}}\right)=\mu\left({\mathcal{A}}\setminus{\mathcal{S}}_{\mathcal{Q}}\right)=\int_{{\mathcal{A}}\setminus{\mathcal{S}}_{\mathcal{Q}}}d\mu.$$
* [10] M. C.  
In particular, we have ν(A) = 0 for any subset *A ⊆ S*Q. For proofs we refer to
[4].

In the following we write

$$\int_{u_{\Gamma}}f(X)d X=\int_{u_{\Gamma}}f d\nu$$

* [10] M. C.  
for the integral of an orbifold function f : UΓ → R defined on a measurable subset UΓ ⊆ XΓ . We tacitly assume that all integrals occurring in the following sections exist.

## 4 Graph Quantization

This section extends vector quantization to quantization of graphs.

## 4.1 The Basics

Suppose that Q = (X *, Γ, π*) is a Riemannian orbifold. A *graph quantizer* of size k is a mapping of the form Q : XΓ → C

$\frac{1}{2}\times\frac{1}{2}\times\frac{1}{2}\times\frac{1}{2}$ . 

$\mathbf{a}\in\mathbf{R}$
where C = {Y1, . . . , Yk*} ⊆ X*Γ is a finite set, called *codebook*. The elements Yj ∈ C
are the *code graphs*. The graph quantizer Q partitions the input space XΓ into k disjoint *regions* Rj = {X ∈ XΓ : Q(X) = Yj}