such that their union covers XΓ . By PQ we denote the partition of Q consisting of all k regions Rj .

Suppose that J = {1*, . . . , k*}. The basic operation of a vector quantizer Q
can be written as a composition Q = dQ ◦ eQ of an encoder eQ : XΓ → J and a decoder dQ : *J → C*. The encoder assigns each input graph to a region via the index set J . The decoder maps indices of J referring to regions to code graphs.

## 4.2 Graph Quantizer Performance

We measure the performance of a graph quantizer Q by the expected distortion

$$D(Q)=\mathbb{E}_{X}\left[d\left(X,Q(X)\right)\right]=\int_{X_{\Gamma}}d(X,Q(X))d P(X),$$

where X ∈ XΓ is a random variable with probability measure P = PXΓ
representing the observable graphs to be quantized. The expectation EX is taken with respect to some probability space (XΓ , ΣXΓ
, PXΓ
). The quantity d(*X, Y* )
measures the *distortion* of the random input graph X and code graph Y . Here we consider graph distortion measures that are graph edit distances. An example is the squared metric induced by an optimal alignment kernel

$$d\left(X,Y\right)=\operatorname*{min}_{\mathbf{x}\in X,\mathbf{y}\in Y}\left\|\mathbf{x}-\mathbf{y}\right\|^{2}$$

Using the codebook and partition for the given quantizer Q, we can rewrite the expected distortion by

$$D({\mathcal{C}})=\sum_{j=1}^{k}\int_{{\mathcal{R}}_{j}}d(X,Y)d P(X).$$

## 4.3 The Problem Of Optimal Graph Quantizer Design

The problem of optimal graph quantizer design is stated as follows: Find a codebook C specifying the decoder dQ and a partition PQ specifying the encoder eQ such that the expected distortion D(Q) is minimized. The composite mapping Q = dQ ◦ eQ of the resulting encoder and decoder is then an *optimal graph* quantizer.

An optimal graph quantizer satisfies the following necessary conditions, also known as the *Lloyd-Max conditions*:

1. *Nearest Neighbor Condition*. Given a fixed codebook C, a graph quantizer Q is optimal, if the code vector Q(X) of an input pattern X satisfies the nearest neighbor rule

$$Q(X)=\arg\operatorname*{min}_{Y\in{\mathcal{C}}}d\left(X,Y\right)$$

for all X ∈ XΓ , where ties are resolved according to some rule. A proof is given in Section B.2, Theorem 3.