
## 2.1 Attributed Graphs

To begin with, we first describe the structures we want to quantize.

Let A be a set of *attributes* and let ε ∈ A be a distinguished element denoting the null or *void* element. An *attributed graph* is a tuple X = (*V, α*) consisting of a finite nonempty set V of *vertices* and an attribute function α : V × V → A.

Elements of the set E = {(*i, j*) ∈ V × V : i 6= j and α(*i, j*) 6= ε}
are the *edges* of X. By GA we denote the set of all attributed graphs with attributes from A. The vertex set of an attributed graph X is often referred to as VX and its attribute function as αX.

An *alignment* of a graph X is a graph X0 with VX ⊆ VX0 and

$$\alpha_{X^{\prime}}(i,j)=\left\{\begin{array}{r c l}{{\alpha_{X}(i,j)}}&{{:}}&{{(i,j)\in V_{X}\times V_{X}}}\\ {{\varepsilon}}&{{:}}&{{\mathrm{otherwise}}}\end{array}\right.$$

for all *i, j* ∈ VX0 . Thus, we obtain an alignment of X by adding isolated vertices with null-attribute. The set VX0 \ VX is the set of *aligned vertices*. By A(X) we denote the (infinite) set of all alignments of X.

A *pairwise alignment* of graphs X and Y is a triple (φ, X0, Y 0) consisting of alignments X0 ∈ A(X) and Y
0 ∈ A(Y ) together with a bijective mapping φ : VX0 → VY 0 , i 7→ i φ.

By A(*X, Y* ) we denote the set of all pairwise alignments between X and Y .

Sometimes we briefly write φ instead of (φ, X0, Y 0).

## 2.2 The Graph Edit Distance

Fundamental for quantizing data is the notion of distortion. This section briefly introduces the graph edit distance functions as our choice of distortion measure. For a more detailed definition of the graph edit distance, we refer to [2]. In addition, we present an important graph metric based on a generalization of the concept of maximum common subgraph, which arises in various different guises as a common choice of proximity measure [1, 5, 6, 15, 32, 33]. For sake of convenience, we assume that all distances are metrics.

Each pairwise alignment (φ, X0, Y 0) ∈ A(*X, Y* ) can be regarded as an edit path with cost

$$d_{\phi}\left(X,Y\right)=\sum_{i,j\in V_{X^{\prime}}}d_{\mathcal{A}}\left(\alpha_{X^{\prime}}(i,j),\alpha_{Y^{\prime}}(i^{\phi},j^{\phi})\right),$$

where dA : *A×A →* R+ is a distance function defined on the set A of attributes.

Observe that deletion (insertion) of vertices also deletes (inserts) all edges the respective vertices are incident to.