The *graph edit distance* of X and Y is then defined as the edit path with minimal cost d(*X, Y* ) = min {dφ (*X, Y* ) : φ ∈ A(*X, Y* )} .

Note that the set A(*X, Y* ) of pairwise alignments is of infinite cardinality. But since dA(*ε, ε*) = 0, we actually take the minimum over a finite subset by ignoring all pairwise alignments that map aligned vertices with null-attributes onto each other.

Next, we consider an important example of the graph edit distance based on a generalization of the concept of maximum common subgraph. We derive this graph metric from a similarity measure in the same way the Euclidean distance is derived from an inner product.

Suppose that kA : *A × A →* R with kA(·, ε) = 0 is a positive definite kernel.

We measure the quality of a pairwise alignment φ ∈ A(*X, Y* ) by

$$k_{\phi}(X,Y)=\sum_{i,j\in V x}k_{\mathcal{A}}\left(\alpha_{X}(i,j),\alpha_{Y}(i^{\phi},j^{\phi})\right).$$

An *optimal alignment kernel* is a graph similarity measure of the form k(*X, Y* ) = max {kφ(*X, Y* ) : φ ∈ A(*X, Y* )} . (1)
Note that k (·|·) is symmetric but indefinite as a pointwise maximizer of a set of positive definite kernels.

The distance metric on GA induced by an optimal alignment kernel k (·|·) is defined by

$$d(X,Y)=\sqrt{l(X)^{2}-2k(X,Y)+l(Y)^{2}},$$
2, (2)
where l(X) = pk(*X, X*) denotes the *length* of an attributed graph X. As shown in [23], d is indeed a metric and can be expressed as a graph edit distance.

## 2.3 The Problem Of Graph Quantizer Design

Let (GA, d) be a graph distance space, where d (·|·) is a graph edit distance.

Optimal graph quantization design aims at minimizing the expected distortion

$$D({\mathcal{C}})=\int_{{\mathcal{G}}_{A}}d(X,Q(X))\,d P(X),$$

where Q : GA → C is a graph quantizer, C = {Y1*, . . . , Y*k} a codebook consisting of k code graphs, and P = PGA is a probability measure defined on some appropriate measurable space (GA, ΣGA ).

As opposed to vector quantization, the following factors complicate designing an optimal graph quantizer in a statistically consistent way:

1. The graph distance d(*X, Y* ) is in general non-convex and non-differentiable.

2. Neither a well-defined addition on graphs nor the notion of derivative for functions on graphs is known.