With both assumptions in mind, we construct the Riemannian orbifold of attributed graphs. Let X = Hn×n be the set of all (n×n)-matrices with elements from feature space H. A graph X is completely specified by a *representation* matrix X = (xij ) from X with elements

$$\mathbf{x}_{i j}={\left\{\begin{array}{l l l}{\phi\left(\mu_{X}(i)\right)}&{:}&{i=j}\\ {\phi\left(\nu_{X}(i,j)\right)}&{:}&{(i,j)\in E}\\ {\mathbf{0}}&{:}&{{\mathrm{otherwise}}}\end{array}\right.}$$

for all *i, j* ∈ VX. The form of a representation matrix X of X is generally not unique and depends on how the vertices are arranged in the diagonal of X.

Now suppose that Πn be the set of all (n × n)-permutation matrices. For each P ∈ Πn we define a mapping

## Γp : X → X , X 7→ P Txp .

Then Γ = {γP : P ∈ Πn} is a permutation group acting on X . Regarding an arbitrary matrix X as a representation of some graph X, then the orbit [X]
consists of all possible matrices that can represent X. By identifying the orbits of XΓ with attributed graphs, the set GA of attributed graphs of bounded order n is a Riemannian orbifold.

## 3.3 Metric Structures

Let Q = (X *, Γ, π*) be an orbifold. We derive an intrinsic metric that enables us to do Riemannian geometry. In the case of a Riemannian orbifold of attributed graphs the intrinsic metric coincides with the graph metric of (2) induced by an optimal alignment kernel.

Any inner product h·, ·i on X gives rise to a maximizer of the form

$$k:{\mathfrak{A}}$$

k : XΓ × XΓ → R, (*X, Y* ) 7→ max {hx, yi : x ∈ X, y ∈ Y } .

We call the kernel function k(·|·) *optimal alignment kernel*, induced by the inner product h·, ·i. Note that the maximizer of a set of positive definite kernels is an indefinite kernel in general. Since Γ is a group, we find that

$$\{\langle\mathbf{x},\mathbf{y}\rangle\,:\,\mathbf{x}\in X,\mathbf{y}\in Y\}$$

k(*X, Y* ) = max {hx, yi : x ∈ X} .

where y is an arbitrary but fixed vector representation of Y . In general, we have k(X, Y ) ≥ hx, yi

## For All X ∈ X And Y ∈ Y .

Example 2. Consider the Riemannian orbifold (X *, Γ, π*) of Example 1, where X = R
2 and Γ = {id, γ} is the group generated by reflections across the x-yplane. Suppose that x = (1, 2) is a vector representation of X and y = (3, 2) is a